/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.encrypt;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.encrypt.Messages;

public class PageAlgorithms
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "EncryptPageAlgorithms";
    private Combo cEncryptionAlgorithm = null;
    private Combo cKeyWrapAlgorithm = null;
    private Text tID = null;
    private Button bSigWiz = null;
    private Button bContentOnly = null;
    private boolean bsp;
    private IFile file;
    private String[] ids;
    private Encryption encryption = null;

    public PageAlgorithms(Encryption encryption, IFile file) {
        super(PAGE_NAME);
        this.setTitle(Messages.encryptionTitle);
        this.setDescription(Messages.algorithmsDescription);
        this.encryption = encryption;
        this.file = file;
        this.determineIds();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.addListeners();
        this.setControl((Control)container);
        this.loadSettings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_encryption_algorithms");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        parent.setLayout((Layout)layout);
        Group gEncrypt = new Group(parent, 16);
        gEncrypt.setLayout((Layout)layout);
        gEncrypt.setText(Messages.algorithms);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gEncrypt.setLayoutData((Object)data);
        Group gContent = new Group(parent, 16);
        gContent.setLayout((Layout)layout);
        gContent.setText(Messages.properties);
        data = new FormData();
        data.top = new FormAttachment((Control)gEncrypt, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gContent.setLayoutData((Object)data);
        Group gID = new Group(parent, 16);
        gID.setLayout((Layout)layout);
        gID.setText(Messages.encryptionId);
        data = new FormData();
        data.top = new FormAttachment((Control)gContent, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gID.setLayoutData((Object)data);
        Group gSigWiz = new Group(parent, 16);
        gSigWiz.setLayout((Layout)layout);
        gSigWiz.setText(Messages.signatureWizard);
        data = new FormData();
        data.top = new FormAttachment((Control)gID, 20, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gSigWiz.setLayoutData((Object)data);
        this.cEncryptionAlgorithm = new Combo((Composite)gEncrypt, 8);
        data = new FormData();
        data.top = new FormAttachment((Control)gEncrypt);
        data.left = new FormAttachment((Control)gEncrypt);
        data.width = 200;
        this.cEncryptionAlgorithm.setLayoutData((Object)data);
        this.cKeyWrapAlgorithm = new Combo((Composite)gEncrypt, 8);
        data = new FormData();
        data.top = new FormAttachment((Control)gEncrypt);
        data.left = new FormAttachment((Control)this.cEncryptionAlgorithm, 20);
        data.width = 200;
        this.cKeyWrapAlgorithm.setLayoutData((Object)data);
        this.bContentOnly = new Button((Composite)gContent, 32);
        this.bContentOnly.setText(Messages.keepRootElementPlain);
        data = new FormData();
        data.top = new FormAttachment((Control)gContent);
        data.left = new FormAttachment((Control)gContent);
        this.bContentOnly.setLayoutData((Object)data);
        Label lID = new Label((Composite)gID, 4);
        lID.setText(Messages.encryptionId);
        data = new FormData();
        data.top = new FormAttachment((Control)gID);
        data.left = new FormAttachment((Control)gID);
        data.width = 90;
        lID.setLayoutData((Object)data);
        this.tID = new Text((Composite)gID, 4);
        this.tID.setTextLimit(20);
        data = new FormData();
        data.top = new FormAttachment((Control)gID);
        data.left = new FormAttachment((Control)lID);
        data.width = 225;
        this.tID.setLayoutData((Object)data);
        this.bSigWiz = new Button((Composite)gSigWiz, 32);
        this.bSigWiz.setText(Messages.startSignatureWizard);
        data = new FormData();
        data.top = new FormAttachment((Control)gSigWiz);
        data.left = new FormAttachment((Control)gSigWiz);
        this.bSigWiz.setLayoutData((Object)data);
    }

    private void addListeners() {
        this.cEncryptionAlgorithm.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.cKeyWrapAlgorithm.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.tID.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8 || e.keyCode == 127) {
                    e.doit = true;
                } else if (!Utils.validateId((String)e.text)) {
                    e.doit = false;
                }
            }
        });
        this.tID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (message == null && this.getErrorMessage() == null) {
            this.setPageComplete(true);
            this.saveDataToModel();
        } else {
            this.setPageComplete(false);
        }
    }

    private void dialogChanged() {
        boolean uniqueId;
        if (this.cEncryptionAlgorithm.getText().equals("")) {
            this.updateStatus(Messages.selectEncryptionAlgorithm, 1);
            return;
        }
        if (this.cKeyWrapAlgorithm.getText().equals("")) {
            this.updateStatus(Messages.selectKeyWrapAlgorithm, 1);
            return;
        }
        if (!this.tID.getText().equals("") && this.ids.length > 0 && !(uniqueId = Utils.ensureIdIsUnique((String)this.tID.getText(), (String[])this.ids))) {
            this.updateStatus(Messages.ambiguousEncryptionId, 3);
            return;
        }
        this.updateStatus(null, 0);
    }

    public void handleEvent(Event e) {
    }

    private void determineIds() {
        try {
            this.ids = Utils.getAllIds((InputStream)this.file.getContents());
        }
        catch (Exception exception) {
            this.ids = new String[0];
        }
    }

    public boolean isPageComplete() {
        this.saveDataToModel();
        return this.getMessage() == null && this.getErrorMessage() == null;
    }

    public boolean performFinish() {
        return this.saveDataToModel();
    }

    private boolean saveDataToModel() {
        this.encryption.setEncryptionAlgorithm(this.cEncryptionAlgorithm.getText());
        this.encryption.setKeyWrapAlgorithm(this.cKeyWrapAlgorithm.getText());
        this.encryption.setContent(this.bContentOnly.getSelection());
        this.encryption.setEncryptionId(this.tID.getText());
        this.encryption.setLaunchSignatureWizard(this.bSigWiz.getSelection());
        this.storeSettings();
        return true;
    }

    public void onEnterPage() {
        this.bsp = this.encryption.getBsp();
        if (this.bsp) {
            this.cEncryptionAlgorithm.setItems(Algorithms.ENCRYPTION_ALGORITHMS_BSP);
            this.cEncryptionAlgorithm.setText(Algorithms.ENCRYPTION_ALGORITHMS_BSP[0]);
            this.cKeyWrapAlgorithm.setItems(Algorithms.KEY_WRAP_ALGORITHMS_BSP);
            this.cKeyWrapAlgorithm.setText(Algorithms.KEY_WRAP_ALGORITHMS_BSP[0]);
        } else {
            this.cEncryptionAlgorithm.setItems(Algorithms.ENCRYPTION_ALGORITHMS);
            this.cEncryptionAlgorithm.setText(Algorithms.ENCRYPTION_ALGORITHMS[0]);
            this.cKeyWrapAlgorithm.setItems(Algorithms.KEY_WRAP_ALGORITHMS);
            this.cKeyWrapAlgorithm.setText(Algorithms.KEY_WRAP_ALGORITHMS[0]);
        }
        this.setMessage(null);
    }

    private void loadSettings() {
        String callSignatureWizard = this.getDialogSettings().get("enc_sign");
        boolean doCallSignatureWizard = false;
        if (callSignatureWizard != null) {
            doCallSignatureWizard = this.getDialogSettings().getBoolean("enc_sign");
        }
        String plainRootElement = this.getDialogSettings().get("enc_plain_root_element");
        boolean doPlainRootElement = false;
        if (plainRootElement != null) {
            doPlainRootElement = this.getDialogSettings().getBoolean("enc_plain_root_element");
        }
        this.bContentOnly.setSelection(doPlainRootElement);
        this.bSigWiz.setSelection(doCallSignatureWizard);
    }

    private void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("enc_plain_root_element", this.bContentOnly.getSelection());
        settings.put("enc_sign", this.bSigWiz.getSelection());
    }
}

