/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.encrypt;

import java.io.File;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.encrypt.Messages;
import org.eclipse.wst.xml.security.ui.encrypt.NewEncryptionWizard;
import org.eclipse.wst.xml.security.ui.encrypt.PageAlgorithms;

public class PageCreateKey
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "EncryptPageCreateKey";
    private String path;
    private String name;
    private boolean generated = false;
    private Button bOpen = null;
    private Button bGenerate = null;
    private Button bEchoKeystorePassword = null;
    private Button bEchoKeyPassword = null;
    private Combo cKeyAlgorithm = null;
    private Combo cKeyAlgorithmSize = null;
    private Label lResult = null;
    private Text tKeyName = null;
    private Text tKeystore = null;
    private Text tKeystorePassword = null;
    private Text tKeyPassword = null;
    private static final int LABELWIDTH = 120;
    private static final int TEXTHEIGHT = 40;
    private Encryption encryption = null;
    private Keystore keystore = null;

    public PageCreateKey(Encryption encryption, String path, String name) {
        super(PAGE_NAME);
        this.setTitle(Messages.encryptionTitle);
        this.setDescription(Messages.createKeyDescription);
        this.encryption = encryption;
        this.path = path;
        this.name = name;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        this.createPageContent(container);
        this.loadSettings();
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_encryption_create_key");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gKeystore = new Group(parent, 16);
        gKeystore.setLayout((Layout)layout);
        gKeystore.setText(Messages.keystore);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKeystore.setLayoutData((Object)data);
        Group gKey = new Group(parent, 16);
        gKey.setLayout((Layout)layout);
        gKey.setText(Messages.key);
        data = new FormData();
        data.top = new FormAttachment((Control)gKeystore, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKey.setLayoutData((Object)data);
        Label lKeystore = new Label((Composite)gKeystore, 4);
        lKeystore.setText(Messages.name);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)gKeystore);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystore.setLayoutData((Object)data);
        this.tKeystore = new Text((Composite)gKeystore, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystore);
        data.width = 200;
        this.tKeystore.setLayoutData((Object)data);
        this.bOpen = new Button((Composite)gKeystore, 8);
        this.bOpen.setText(Messages.open);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystore, 10);
        this.bOpen.setLayoutData((Object)data);
        Label lKeystorePassword = new Label((Composite)gKeystore, 4);
        lKeystorePassword.setText(Messages.password);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)lKeystore, 10);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystorePassword.setLayoutData((Object)data);
        this.tKeystorePassword = new Text((Composite)gKeystore, 4);
        this.tKeystorePassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystorePassword);
        this.tKeystorePassword.setEchoChar('*');
        this.tKeystorePassword.setLayoutData((Object)data);
        this.bEchoKeystorePassword = new Button((Composite)gKeystore, 8);
        this.bEchoKeystorePassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        this.bEchoKeystorePassword.setToolTipText(Messages.echoPassword);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystorePassword, 10);
        this.bEchoKeystorePassword.setLayoutData((Object)data);
        Label lKeyAlgorithm = new Label((Composite)gKey, 4);
        lKeyAlgorithm.setText(Messages.keyAlgorithm);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)gKey);
        data.left = new FormAttachment((Control)gKey);
        lKeyAlgorithm.setLayoutData((Object)data);
        this.cKeyAlgorithm = new Combo((Composite)gKey, 8);
        this.cKeyAlgorithm.setItems(Algorithms.ENCRYPTION_KEY_ALOGRITHMS);
        this.cKeyAlgorithm.setText(Algorithms.ENCRYPTION_KEY_ALOGRITHMS[0]);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyAlgorithm, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyAlgorithm);
        data.width = 150;
        this.cKeyAlgorithm.setLayoutData((Object)data);
        Label lKeyAlgorithmSize = new Label((Composite)gKey, 4);
        lKeyAlgorithmSize.setText(Messages.keyAlgorithmSize);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)lKeyAlgorithm, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyAlgorithmSize.setLayoutData((Object)data);
        this.cKeyAlgorithmSize = new Combo((Composite)gKey, 8);
        this.cKeyAlgorithmSize.setItems(Algorithms.KEY_SIZES_AES);
        this.cKeyAlgorithmSize.setText(Algorithms.KEY_SIZES_AES[0]);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyAlgorithmSize, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyAlgorithmSize);
        data.width = 150;
        this.cKeyAlgorithmSize.setLayoutData((Object)data);
        Label lKeyName = new Label((Composite)gKey, 4);
        lKeyName.setText(Messages.name);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)lKeyAlgorithmSize, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyName.setLayoutData((Object)data);
        this.tKeyName = new Text((Composite)gKey, 4);
        this.tKeyName.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyName);
        this.tKeyName.setLayoutData((Object)data);
        Label lKeyPassword = new Label((Composite)gKey, 4);
        lKeyPassword.setText(Messages.password);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)lKeyName, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyPassword.setLayoutData((Object)data);
        this.tKeyPassword = new Text((Composite)gKey, 4);
        this.tKeyPassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyPassword);
        this.tKeyPassword.setEchoChar('*');
        this.tKeyPassword.setLayoutData((Object)data);
        this.bEchoKeyPassword = new Button((Composite)gKey, 8);
        this.bEchoKeyPassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        this.bEchoKeyPassword.setToolTipText(Messages.echoPassword);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeyPassword, 10);
        this.bEchoKeyPassword.setLayoutData((Object)data);
        this.bGenerate = new Button((Composite)gKey, 8);
        this.bGenerate.setText(Messages.generateButton);
        this.bGenerate.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyPassword, 20);
        data.left = new FormAttachment((Control)gKey);
        this.bGenerate.setLayoutData((Object)data);
        this.lResult = new Label((Composite)gKey, 64);
        data = new FormData();
        data.height = 40;
        data.top = new FormAttachment((Control)this.bGenerate, 20);
        data.left = new FormAttachment((Control)gKey);
        data.right = new FormAttachment(100);
        this.lResult.setLayoutData((Object)data);
    }

    private void addListeners() {
        this.bOpen.addListener(13, (Listener)this);
        this.bGenerate.addListener(3, (Listener)this);
        this.bEchoKeyPassword.addListener(13, (Listener)this);
        this.bEchoKeystorePassword.addListener(13, (Listener)this);
        this.cKeyAlgorithm.addListener(13, (Listener)this);
        this.tKeyName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
    }

    private void dialogChanged() {
        if (this.tKeystore.getText().length() == 0) {
            this.updateStatus(Messages.selectKeystoreFileToExtend, 1);
            return;
        }
        if (this.tKeystorePassword.getText().length() == 0) {
            this.updateStatus(Messages.enterKeystorePassword, 1);
            return;
        }
        if (this.tKeyName.getText().length() < 4 || this.tKeyName.getText().length() > 20) {
            this.updateStatus(Messages.enterNewKeyName, 1);
            return;
        }
        if (this.tKeyPassword.getText().length() < 6 || this.tKeyPassword.getText().length() > 20) {
            this.updateStatus(Messages.enterNewKeyPassword, 1);
            return;
        }
        try {
            this.keystore = new Keystore(this.tKeystore.getText(), this.tKeystorePassword.getText(), "JCEKS");
            this.keystore.load();
            if (this.keystore.containsKey(this.tKeyName.getText())) {
                this.updateStatus(Messages.existingKeyName, 0);
                return;
            }
        }
        catch (Exception exception) {
            this.updateStatus(Messages.verifyAll, 0);
            return;
        }
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (!this.generated && message == null) {
            this.bGenerate.setEnabled(true);
        } else {
            this.bGenerate.setEnabled(false);
        }
        this.setPageComplete(this.generated);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bOpen) {
            this.openKeystore();
        } else if (e.widget == this.bGenerate) {
            this.createKey();
            this.updateStatus(null, 0);
        } else if (e.widget == this.bEchoKeystorePassword) {
            this.echoPassword(e);
        } else if (e.widget == this.bEchoKeyPassword) {
            this.echoPassword(e);
        } else if (e.widget == this.cKeyAlgorithm) {
            if (this.cKeyAlgorithm.getText().equalsIgnoreCase("AES")) {
                this.cKeyAlgorithmSize.setItems(Algorithms.KEY_SIZES_AES);
                this.cKeyAlgorithmSize.setText(Algorithms.KEY_SIZES_AES[0]);
            } else if (this.cKeyAlgorithm.getText().equalsIgnoreCase("Blowfish")) {
                this.cKeyAlgorithmSize.setItems(Algorithms.KEY_SIZES_BLOWFISH);
                this.cKeyAlgorithmSize.setText(Algorithms.KEY_SIZES_BLOWFISH[0]);
            } else if (this.cKeyAlgorithm.getText().equalsIgnoreCase("DES")) {
                this.cKeyAlgorithmSize.setItems(Algorithms.KEY_SIZES_DES);
                this.cKeyAlgorithmSize.setText(Algorithms.KEY_SIZES_DES[0]);
            } else if (this.cKeyAlgorithm.getText().equalsIgnoreCase("DESede")) {
                this.cKeyAlgorithmSize.setItems(Algorithms.KEY_SIZES_DESEDE);
                this.cKeyAlgorithmSize.setText(Algorithms.KEY_SIZES_DESEDE[0]);
            } else {
                this.cKeyAlgorithmSize.setItems(Algorithms.ENCRYPTION_KEY_ALGORITHMS_SIZES);
                this.cKeyAlgorithmSize.setText(Algorithms.ENCRYPTION_KEY_ALGORITHMS_SIZES[0]);
            }
        }
    }

    private void echoPassword(Event e) {
        if (e.widget == this.bEchoKeystorePassword) {
            if (this.tKeystorePassword.getEchoChar() == '*') {
                this.tKeystorePassword.setEchoChar('\u0000');
            } else {
                this.tKeystorePassword.setEchoChar('*');
            }
            this.tKeystorePassword.redraw();
        } else if (e.widget == this.bEchoKeyPassword) {
            if (this.tKeyPassword.getEchoChar() == '*') {
                this.tKeyPassword.setEchoChar('\u0000');
            } else {
                this.tKeyPassword.setEchoChar('*');
            }
            this.tKeyPassword.redraw();
        }
    }

    private void openKeystore() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(Globals.KEY_STORE_EXTENSION_NAME);
        dialog.setFilterExtensions(Globals.KEY_STORE_EXTENSION);
        dialog.setFilterPath(this.path);
        String file = dialog.open();
        if (file != null && file.length() > 0) {
            this.tKeystore.setText(file);
        }
    }

    private void createKey() {
        try {
            this.keystore = new Keystore(this.tKeystore.getText(), this.tKeystorePassword.getText(), "JCEKS");
            this.keystore.load();
            SecretKey key = this.keystore.generateSecretKey(this.cKeyAlgorithm.getText(), Integer.parseInt(this.cKeyAlgorithmSize.getText()));
            this.generated = this.keystore.insertSecretKey(this.tKeyName.getText(), this.tKeyPassword.getText().toCharArray(), key);
            this.keystore.store();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.generated = false;
            this.lResult.setText(Messages.keyGenerationFailed);
        }
        catch (Exception exception) {
            this.generated = false;
            this.lResult.setText(Messages.keyInsertionFailed);
        }
        if (this.generated) {
            String keystoreName = this.tKeystore.getText().substring(this.tKeystore.getText().lastIndexOf(File.separator) + 1);
            this.lResult.setText(NLS.bind((String)Messages.keyGenerated, (Object[])new Object[]{this.tKeyName.getText(), keystoreName, this.name}));
            this.updateStatus(null, 0);
        }
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        PageAlgorithms page = ((NewEncryptionWizard)this.getWizard()).getPageAlgorithms();
        page.onEnterPage();
        return page;
    }

    private void saveDataToModel() {
        this.encryption.setKeystore(this.keystore);
        this.encryption.setKeystorePassword(this.tKeystorePassword.getText().toCharArray());
        this.encryption.setKeyName(this.tKeyName.getText());
        this.encryption.setKeyPassword(this.tKeyPassword.getText().toCharArray());
        this.storeSettings();
    }

    private void loadSettings() {
        String previousKeystore = this.getDialogSettings().get("enc_keystore");
        if (previousKeystore == null) {
            previousKeystore = "";
        }
        this.tKeystore.setText(previousKeystore);
    }

    private void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("enc_keystore", this.tKeystore.getText());
    }
}

