/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.encrypt;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.dialogs.XpathDialog;
import org.eclipse.wst.xml.security.ui.encrypt.Messages;
import org.eclipse.wst.xml.security.ui.encrypt.NewEncryptionWizard;
import org.eclipse.wst.xml.security.ui.encrypt.PageCreateKey;
import org.eclipse.wst.xml.security.ui.encrypt.PageCreateKeystore;
import org.eclipse.wst.xml.security.ui.encrypt.PageOpenKey;
import org.w3c.dom.Document;

public class PageResource
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "EncryptPageResource";
    private Button bBrowseXpath = null;
    private Button bSelectDetachedFile = null;
    private Button bBsp = null;
    private Button bDocument = null;
    private Button bSelection = null;
    private Button bXpath = null;
    private Button bDetached = null;
    private Button bEnveloping = null;
    private Button bCreateKeystore = null;
    private Button bCreateKey = null;
    private Button bOpenKey = null;
    private Text tXpath = null;
    private Text tDetachedFile = null;
    private IFile file = null;
    private boolean textSelection;
    private Document document = null;
    private static final String EMPTY = "";
    private Encryption encryption = null;

    public PageResource(Encryption encryption, IFile file, boolean textSelection) {
        super(PAGE_NAME);
        this.setTitle(Messages.encryptionTitle);
        this.setDescription(Messages.resourceDescription);
        this.encryption = encryption;
        this.file = file;
        this.textSelection = textSelection;
        try {
            this.document = Utils.parse((IFile)file);
        }
        catch (Exception exception) {
            this.updateStatus(Messages.documentInvalid, 3);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.addListeners();
        this.setControl((Control)container);
        this.loadSettings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_encryption_resource");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gResource = new Group(parent, 16);
        gResource.setLayout((Layout)layout);
        gResource.setText(Messages.resource);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gResource.setLayoutData((Object)data);
        Group gType = new Group(parent, 16);
        gType.setLayout((Layout)layout);
        gType.setText(Messages.encryptionType);
        data = new FormData();
        data.top = new FormAttachment((Control)gResource, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gType.setLayoutData((Object)data);
        Group gKey = new Group(parent, 16);
        gKey.setLayout((Layout)layout);
        gKey.setText(Messages.keystoreAndKey);
        data = new FormData();
        data.top = new FormAttachment((Control)gType, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKey.setLayoutData((Object)data);
        Group gBsp = new Group(parent, 16);
        gBsp.setLayout((Layout)layout);
        gBsp.setText(Messages.basicSecurityProfile);
        data = new FormData();
        data.top = new FormAttachment((Control)gKey, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gBsp.setLayoutData((Object)data);
        this.bDocument = new Button((Composite)gResource, 16);
        this.bDocument.setText(Messages.document);
        this.bDocument.setSelection(true);
        data = new FormData();
        data.top = new FormAttachment((Control)gResource);
        data.left = new FormAttachment((Control)gResource);
        this.bDocument.setLayoutData((Object)data);
        this.bSelection = new Button((Composite)gResource, 16);
        this.bSelection.setText(Messages.selection);
        this.bSelection.setEnabled(this.textSelection);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bDocument, 10);
        data.left = new FormAttachment((Control)gResource);
        this.bSelection.setLayoutData((Object)data);
        this.bXpath = new Button((Composite)gResource, 16);
        this.bXpath.setText(Messages.xpath);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bSelection, 10);
        data.left = new FormAttachment((Control)gResource);
        this.bXpath.setLayoutData((Object)data);
        this.tXpath = new Text((Composite)gResource, 4);
        this.tXpath.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bXpath, 0, 0x1000000);
        data.left = new FormAttachment((Control)gResource, 100);
        data.width = 225;
        this.tXpath.setLayoutData((Object)data);
        this.bBrowseXpath = new Button((Composite)gResource, 8);
        this.bBrowseXpath.setEnabled(false);
        this.bBrowseXpath.setText(Messages.browse);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bXpath, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tXpath, 10);
        this.bBrowseXpath.setLayoutData((Object)data);
        this.bEnveloping = new Button((Composite)gType, 16);
        this.bEnveloping.setText(Messages.encryptionEnveloping);
        this.bEnveloping.setSelection(true);
        data = new FormData();
        data.top = new FormAttachment((Control)gType);
        data.left = new FormAttachment((Control)gType);
        this.bEnveloping.setLayoutData((Object)data);
        this.bDetached = new Button((Composite)gType, 16);
        this.bDetached.setText(Messages.encryptionDetached);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bEnveloping, 10);
        data.left = new FormAttachment((Control)gType);
        this.bDetached.setLayoutData((Object)data);
        this.tDetachedFile = new Text((Composite)gType, 4);
        this.tDetachedFile.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bDetached, 0, 0x1000000);
        data.left = new FormAttachment((Control)gType, 100);
        data.width = 225;
        this.tDetachedFile.setLayoutData((Object)data);
        this.bSelectDetachedFile = new Button((Composite)gType, 8);
        this.bSelectDetachedFile.setText(Messages.select);
        this.bSelectDetachedFile.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bDetached, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tDetachedFile, 10);
        this.bSelectDetachedFile.setLayoutData((Object)data);
        this.bOpenKey = new Button((Composite)gKey, 16);
        this.bOpenKey.setText(Messages.openKey);
        this.bOpenKey.setSelection(true);
        data = new FormData();
        data.top = new FormAttachment((Control)gKey);
        data.left = new FormAttachment((Control)gKey);
        this.bOpenKey.setLayoutData((Object)data);
        this.bCreateKey = new Button((Composite)gKey, 16);
        this.bCreateKey.setText(Messages.createKey);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bOpenKey, 10);
        data.left = new FormAttachment((Control)gKey);
        this.bCreateKey.setLayoutData((Object)data);
        this.bCreateKeystore = new Button((Composite)gKey, 16);
        this.bCreateKeystore.setText(Messages.createKeystoreAndKey);
        data = new FormData();
        data.top = new FormAttachment((Control)this.bCreateKey, 10);
        data.left = new FormAttachment((Control)gKey);
        this.bCreateKeystore.setLayoutData((Object)data);
        this.bBsp = new Button((Composite)gBsp, 32);
        this.bBsp.setText(Messages.bspCompliant);
        data = new FormData();
        data.top = new FormAttachment((Control)gBsp);
        data.left = new FormAttachment((Control)gBsp);
        this.bBsp.setLayoutData((Object)data);
    }

    private void addListeners() {
        this.bSelectDetachedFile.addListener(13, (Listener)this);
        this.bBrowseXpath.addListener(13, (Listener)this);
        this.bBsp.addListener(13, (Listener)this);
        this.bDocument.addListener(13, (Listener)this);
        this.bSelection.addListener(13, (Listener)this);
        this.bDetached.addListener(13, (Listener)this);
        this.bEnveloping.addListener(13, (Listener)this);
        this.bXpath.addListener(13, (Listener)this);
        this.tXpath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
        this.tDetachedFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
    }

    private void dialogChanged() {
        File tempFile;
        if (this.bXpath.getSelection() && this.tXpath.getText().length() == 0) {
            this.updateStatus(Messages.enterXPath, 1);
            return;
        }
        if (this.bXpath.getSelection() && this.tXpath.getText().length() > 0) {
            String xpathValidator = Utils.validateXPath((Document)this.document, (String)this.tXpath.getText());
            if (xpathValidator.equals("none")) {
                this.updateStatus(Messages.xpathNoElement, 3);
                return;
            }
            if (xpathValidator.equals("multiple")) {
                this.updateStatus(Messages.xpathMultipleElements, 3);
                return;
            }
            if (xpathValidator.equals("attribute")) {
                this.updateStatus(Messages.xpathAttribute, 3);
                return;
            }
        }
        if (this.bDetached.getSelection() && this.tDetachedFile.getText().length() == 0) {
            this.updateStatus(Messages.detachedFile, 1);
            return;
        }
        if (this.bDetached.getSelection() && this.tDetachedFile.getText().length() > 0 && !(tempFile = new File(this.tDetachedFile.getText())).exists()) {
            this.updateStatus(Messages.verifyDetachedFile, 3);
            return;
        }
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (message == null && this.getErrorMessage() == null) {
            this.setPageComplete(true);
            this.saveDataToModel();
        } else {
            this.setPageComplete(false);
        }
    }

    private void openXPathDialog() {
        Object[] selected;
        XpathDialog dialog = new XpathDialog(this.getShell(), (ILabelProvider)new LabelProvider(), this.file, Messages.xpathPopup);
        if (dialog.getReturnCode() == 0 && (selected = dialog.getResult()).length == 1) {
            this.tXpath.setText(selected[0].toString());
        }
    }

    private void selectDetachedFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterPath(this.file.getLocation().removeFileExtension().removeLastSegments(1).toString());
        dialog.setFilterNames(Globals.DETACHED_FILE_EXTENSION_NAME);
        dialog.setFilterExtensions(Globals.DETACHED_FILE_EXTENSION);
        String detachedFile = dialog.open();
        if (detachedFile != null && detachedFile.length() > 0) {
            this.tDetachedFile.setText(detachedFile);
        }
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bDocument || e.widget == this.bSelection) {
            this.tXpath.setEnabled(false);
            this.tXpath.setText(EMPTY);
            this.bBrowseXpath.setEnabled(false);
        } else if (e.widget == this.bXpath) {
            this.tXpath.setEnabled(true);
            this.bBrowseXpath.setEnabled(true);
        } else if (e.widget == this.bBrowseXpath) {
            this.openXPathDialog();
        } else if (e.widget == this.bSelectDetachedFile) {
            this.selectDetachedFile();
        } else if (e.widget == this.bEnveloping) {
            this.bSelectDetachedFile.setEnabled(false);
            this.tDetachedFile.setEnabled(false);
            this.tDetachedFile.setText(EMPTY);
            this.bXpath.setEnabled(true);
            if (this.textSelection) {
                this.bSelection.setEnabled(true);
            }
        } else if (e.widget == this.bDetached) {
            this.bDocument.setSelection(true);
            this.bSelection.setSelection(false);
            this.bXpath.setSelection(false);
            this.bSelection.setEnabled(false);
            this.bXpath.setEnabled(false);
            this.tXpath.setText(EMPTY);
            this.tXpath.setEnabled(false);
            this.bBrowseXpath.setEnabled(false);
            this.tDetachedFile.setEnabled(true);
            this.bSelectDetachedFile.setEnabled(true);
        } else if (e.widget == this.bSelectDetachedFile) {
            this.selectDetachedFile();
        }
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        if (this.bCreateKey.getSelection()) {
            PageCreateKey page = ((NewEncryptionWizard)this.getWizard()).getPageCreateKey();
            return page;
        }
        if (this.bCreateKeystore.getSelection()) {
            PageCreateKeystore page = ((NewEncryptionWizard)this.getWizard()).getPageCreateKeystore();
            return page;
        }
        PageOpenKey page = ((NewEncryptionWizard)this.getWizard()).getPageOpenKey();
        return page;
    }

    private void saveDataToModel() {
        if (this.bDocument.getSelection()) {
            this.encryption.setResource("document");
        } else if (this.bSelection.getSelection()) {
            this.encryption.setResource("selection");
        } else if (this.bXpath.getSelection()) {
            this.encryption.setResource("xpath");
            this.encryption.setXpath(this.tXpath.getText());
        }
        if (this.bEnveloping.getSelection()) {
            this.encryption.setEncryptionType("enveloping");
        } else if (this.bDetached.getSelection()) {
            this.encryption.setEncryptionType("detached");
            this.encryption.setDetachedFile(new File(this.tDetachedFile.getText()));
        }
        this.encryption.setBsp(this.bBsp.getSelection());
        this.encryption.setFile(this.file.getLocation().toString());
        this.storeSettings();
    }

    private void loadSettings() {
        String bspCompliantEncryption = this.getDialogSettings().get("enc_bsp_compliant");
        boolean doBSPCompliantEncryption = false;
        if (bspCompliantEncryption != null) {
            doBSPCompliantEncryption = this.getDialogSettings().getBoolean("enc_bsp_compliant");
        }
        this.bBsp.setSelection(doBSPCompliantEncryption);
    }

    private void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("enc_bsp_compliant", this.bBsp.getSelection());
    }
}

