/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.views;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.dialogs.NamespaceInfoErrorHelper;
import org.eclipse.wst.xml.ui.internal.dialogs.UpdateListener;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;
import org.eclipse.wst.xml.xpath.ui.XPathUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditNamespacePrefixDialog
extends Dialog
implements UpdateListener {
    protected Label errorMessageLabel;
    protected List<NamespaceInfo> namespaceInfoList;
    protected IPath resourceLocation;

    public EditNamespacePrefixDialog(Shell parentShell, IPath resourceLocation) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.resourceLocation = resourceLocation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        CommonEditNamespacesDialog editNamespacesControl = new CommonEditNamespacesDialog(dialogArea, this.resourceLocation, XPathUIMessages.XPathNavigator_Namespace_Prefixes, false, true);
        editNamespacesControl.setNamespaceInfoList(this.namespaceInfoList);
        editNamespacesControl.updateErrorMessage(this.namespaceInfoList);
        this.getShell().setText(XPathUIMessages.XPathNavigator_Namespace_Prefixes);
        return dialogArea;
    }

    protected Control getDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    public List<NamespaceInfo> getNamespaceInfoList() {
        return this.namespaceInfoList;
    }

    public void setNamespaceInfoList(List<NamespaceInfo> list) {
        this.namespaceInfoList = list;
    }

    public void updateErrorMessage(List<NamespaceInfo> namespaceInfoList) {
        NamespaceInfoErrorHelper helper = new NamespaceInfoErrorHelper();
        String errorMessage = helper.computeErrorMessage(namespaceInfoList, null);
        this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
    }

    public void updateOccured(Object object, Object arg) {
        this.updateErrorMessage((List)arg);
    }
}

