/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.Messages;
import org.eclipse.wst.xsl.launching.IFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesBlock
extends AbstractTableBlock {
    private Table table;
    private TableViewer tViewer;
    private Map<String, String> featureValues;
    private Text descriptionText;
    private DialogPage dialogPage;

    public FeaturesBlock(DialogPage dialogPage) {
        this.dialogPage = dialogPage;
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected String getQualifier() {
        return "org.eclipse.wst.xsl.debug.ui.FEATURES_BLOCK";
    }

    @Override
    protected Table getTable() {
        return this.table;
    }

    public void createControl(Composite parent) {
        this.table = new Table(parent, 68096);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.widthHint = 450;
        this.table.setLayoutData((Object)gd);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn c1 = new TableColumn(this.table, 0);
        c1.setWidth(150);
        c1.setResizable(true);
        c1.setText(Messages.getString("FeaturesBlock.0"));
        TableColumn c2 = new TableColumn(this.table, 0);
        c2.setWidth(100);
        c2.setResizable(true);
        c2.setText(Messages.getString("FeaturesBlock.1"));
        TableColumn c3 = new TableColumn(this.table, 0);
        c3.setWidth(200);
        c3.setResizable(true);
        c3.setText(Messages.getString("FeaturesBlock.2"));
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private IFeature[] features;

            public Object[] getElements(Object inputElement) {
                return this.features;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.features = (IFeature[])newInput;
            }
        });
        this.tViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IFeature feature = (IFeature)element;
                switch (columnIndex) {
                    case 0: {
                        return this.removeURI(feature.getURI());
                    }
                    case 1: {
                        return feature.getType();
                    }
                    case 2: {
                        String value = (String)FeaturesBlock.this.featureValues.get(feature.getURI());
                        return value == null ? "" : value;
                    }
                }
                return "!!";
            }

            private String removeURI(String uri) {
                int index = uri.lastIndexOf(47);
                if (index > 0) {
                    return uri.substring(index + 1);
                }
                return uri;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tViewer.setColumnProperties(new String[]{Messages.getString("FeaturesBlock.5"), Messages.getString("FeaturesBlock.6"), Messages.getString("FeaturesBlock.7")});
        final String[] valid = new String[1];
        this.tViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return Messages.getString("FeaturesBlock.8").equals(property);
            }

            public Object getValue(Object element, String property) {
                IFeature feature = (IFeature)element;
                String value = (String)FeaturesBlock.this.featureValues.get(feature.getURI());
                return value == null ? "" : value;
            }

            public void modify(Object element, String property, Object value) {
                Item item = (Item)element;
                IFeature feature = (IFeature)item.getData();
                if (value == null || "".equals(value)) {
                    FeaturesBlock.this.featureValues.remove(feature.getURI());
                } else {
                    FeaturesBlock.this.featureValues.put(feature.getURI(), (String)value);
                }
                FeaturesBlock.this.setErrorMessage(valid[0]);
                FeaturesBlock.this.tViewer.update((Object)feature, null);
            }
        });
        this.tViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IFeature feature1 = (IFeature)e1;
                IFeature feature2 = (IFeature)e2;
                return feature1.getURI().compareTo(feature2.getURI());
            }
        });
        TextCellEditor editor = new TextCellEditor((Composite)this.table);
        editor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                IStructuredSelection sel = (IStructuredSelection)FeaturesBlock.this.tViewer.getSelection();
                IFeature feature = (IFeature)sel.getFirstElement();
                IStatus validStatus = feature.validateValue((String)value);
                valid[0] = value == null || "".equals(value) ? null : (validStatus != null && validStatus.getSeverity() == 4 ? validStatus.getMessage() : null);
                return valid[0];
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = editor;
        CellEditor[] editors = cellEditorArray;
        this.tViewer.setCellEditors(editors);
        this.tViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String text = null;
                if (selection != null && selection.getFirstElement() != null) {
                    text = ((IFeature)selection.getFirstElement()).getDescription();
                }
                FeaturesBlock.this.descriptionText.setText(text == null ? "" : text);
            }
        });
        this.restoreColumnSettings();
        this.descriptionText = new Text(parent, 2632);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        gd.heightHint = 80;
        this.descriptionText.setLayoutData((Object)gd);
    }

    protected void setInput(IFeature[] input) {
        this.tViewer.setInput((Object)input);
    }

    protected void setFeatureValues(Map<String, String> map) {
        this.featureValues = map;
    }

    public String getName() {
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void setErrorMessage(String errorMessage) {
        this.dialogPage.setErrorMessage(errorMessage);
    }
}

