/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.preferences;

import java.util.Properties;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.Messages;
import org.eclipse.wst.xsl.launching.IOutputProperty;
import org.eclipse.wst.xsl.launching.IProcessorType;

public class OutputBlock
extends AbstractTableBlock {
    private Table table;
    private TableViewer tViewer;
    private Properties properties;

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.debug.ui.OUTPUT_BLOCK";
    }

    protected Table getTable() {
        return this.table;
    }

    public void createControl(Composite parent) {
        this.table = new Table(parent, 68096);
        this.setControl((Control)this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn c1 = new TableColumn(this.table, 0);
        c1.setWidth(450);
        c1.setResizable(true);
        c1.setText(Messages.getString("OutputBlock.0"));
        TableColumn c2 = new TableColumn(this.table, 0);
        c2.setWidth(150);
        c2.setResizable(true);
        c2.setText(Messages.getString("OutputBlock.1"));
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private IOutputProperty[] allProperties;

            public Object[] getElements(Object inputElement) {
                return this.allProperties;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.allProperties = (IOutputProperty[])newInput;
            }
        });
        this.tViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IOutputProperty prop = (IOutputProperty)element;
                switch (columnIndex) {
                    case 0: {
                        return prop.getURI();
                    }
                    case 1: {
                        return (String)OutputBlock.this.properties.get(prop.getURI());
                    }
                }
                return "!!";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tViewer.setColumnProperties(new String[]{Messages.getString("OutputBlock.2"), Messages.getString("OutputBlock.4")});
        this.tViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return Messages.getString("OutputBlock.5").equals(property);
            }

            public Object getValue(Object element, String property) {
                IOutputProperty prop = (IOutputProperty)element;
                String value = (String)OutputBlock.this.properties.get(prop.getURI());
                return value == null ? "" : value;
            }

            public void modify(Object element, String property, Object value) {
                Item item = (Item)element;
                IOutputProperty prop = (IOutputProperty)item.getData();
                if (value == null || "".equals(value)) {
                    OutputBlock.this.properties.remove(prop.getURI());
                } else {
                    OutputBlock.this.properties.put(prop.getURI(), value);
                }
                OutputBlock.this.tViewer.update((Object)prop, null);
            }
        });
        this.tViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IOutputProperty prop1 = (IOutputProperty)e1;
                IOutputProperty prop2 = (IOutputProperty)e2;
                return prop1.getURI().compareTo(prop2.getURI());
            }
        });
        TextCellEditor editor = new TextCellEditor((Composite)this.table);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = editor;
        CellEditor[] editors = cellEditorArray;
        this.tViewer.setCellEditors(editors);
        this.restoreColumnSettings();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tViewer.addSelectionChangedListener(listener);
    }

    public void refresh() {
        this.tViewer.refresh();
    }

    public void setOutputPropertyValues(IProcessorType type, Properties properties) {
        this.properties = properties;
    }

    public void setInput(IOutputProperty[] keys) {
        this.tViewer.setInput((Object)keys);
    }

    public String getName() {
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }
}

