/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.FeaturesPreferencePage;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.OutputBlock;
import org.eclipse.wst.xsl.launching.IOutputProperty;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;

public class OutputPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ComboViewer cViewer;
    private OutputBlock outputBlock;
    private OutputBlock standardOutputBlock;
    private Map<IProcessorType, Properties> typePropertyMap = new HashMap<IProcessorType, Properties>();
    private Text descriptionText;

    public OutputPreferencePage() {
        this.setTitle(Messages.getString("OutputPreferencePage.0"));
        this.setDescription(Messages.getString("OutputPreferencePage.1"));
    }

    protected Control createContents(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("OutputPreferencePage.2"));
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 150;
        gd.widthHint = 450;
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout());
        this.standardOutputBlock = new OutputBlock();
        this.standardOutputBlock.createControl((Composite)group);
        this.standardOutputBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String text = null;
                if (selection != null && selection.getFirstElement() != null) {
                    text = ((IOutputProperty)selection.getFirstElement()).getDescription();
                }
                OutputPreferencePage.this.descriptionText.setText(text == null ? "" : text);
            }
        });
        gd = new GridData(4, 4, true, true);
        this.standardOutputBlock.getControl().setLayoutData((Object)gd);
        group = new Group(parent, 0);
        group.setText(Messages.getString("OutputPreferencePage.4"));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        gd = new GridData(0, 0x1000000, false, false);
        label.setText(Messages.getString("OutputPreferencePage.5"));
        label.setLayoutData((Object)gd);
        Combo combo = new Combo((Composite)group, 12);
        gd = new GridData(0, 0x1000000, false, false);
        combo.setLayoutData((Object)gd);
        this.cViewer = new ComboViewer(combo);
        this.cViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private IProcessorType[] types;

            public Object[] getElements(Object inputElement) {
                return this.types;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.types = (IProcessorType[])newInput;
            }
        });
        this.cViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IProcessorType type = (IProcessorType)element;
                return type.getLabel();
            }
        });
        this.cViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IProcessorType type1 = (IProcessorType)e1;
                IProcessorType type2 = (IProcessorType)e2;
                return type1.getLabel().compareTo(type2.getLabel());
            }
        });
        this.cViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IProcessorType type = (IProcessorType)selection.getFirstElement();
                if (type != null) {
                    OutputPreferencePage.this.outputBlock.setOutputPropertyValues(type, (Properties)OutputPreferencePage.this.typePropertyMap.get(type));
                    OutputPreferencePage.this.outputBlock.setInput(type.getOutputProperties());
                } else {
                    OutputPreferencePage.this.outputBlock.setOutputPropertyValues(type, new Properties());
                    OutputPreferencePage.this.outputBlock.setInput(new IOutputProperty[0]);
                }
            }
        });
        this.cViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IProcessorType type = (IProcessorType)element;
                return !type.equals(XSLTRuntime.getProcessorType((String)"org.eclipse.wst.xsl.launching.processorType.jreDefault"));
            }
        });
        this.outputBlock = new OutputBlock();
        this.outputBlock.createControl((Composite)group);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.outputBlock.getControl().setLayoutData((Object)gd);
        this.standardOutputBlock.getControl().setLayoutData((Object)gd);
        this.outputBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String text = null;
                if (selection != null && selection.getFirstElement() != null) {
                    text = ((IOutputProperty)selection.getFirstElement()).getDescription();
                }
                OutputPreferencePage.this.descriptionText.setText(text == null ? "" : text);
            }
        });
        this.descriptionText = new Text(parent, 2632);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        gd.heightHint = 60;
        this.descriptionText.setLayoutData((Object)gd);
        this.setInput();
        return parent;
    }

    private void setInput() {
        IProcessorType[] types = XSLTRuntime.getProcessorTypes();
        this.typePropertyMap.clear();
        IProcessorType[] iProcessorTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            this.typePropertyMap.put(type, (Properties)type.getOutputPropertyValues().clone());
            ++n2;
        }
        IProcessorType jreDefaultType = XSLTRuntime.getProcessorType((String)"org.eclipse.wst.xsl.launching.processorType.jreDefault");
        this.standardOutputBlock.setOutputPropertyValues(jreDefaultType, this.typePropertyMap.get(jreDefaultType));
        this.standardOutputBlock.setInput(jreDefaultType.getOutputProperties());
        this.cViewer.setInput((Object)types);
        this.cViewer.setSelection((ISelection)new StructuredSelection((Object)FeaturesPreferencePage.getInitialType()), true);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IProcessorType[] types = XSLTRuntime.getProcessorTypes();
        this.typePropertyMap.clear();
        IProcessorType[] iProcessorTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            this.typePropertyMap.put(type, XSLTRuntime.createDefaultOutputProperties((String)type.getId()));
            ++n2;
        }
        IProcessorType jreDefaultType = XSLTRuntime.getProcessorType((String)"org.eclipse.wst.xsl.launching.processorType.jreDefault");
        this.standardOutputBlock.setOutputPropertyValues(jreDefaultType, this.typePropertyMap.get(jreDefaultType));
        this.standardOutputBlock.setInput(jreDefaultType.getOutputProperties());
        this.cViewer.setInput((Object)types);
        this.cViewer.setSelection((ISelection)new StructuredSelection((Object)FeaturesPreferencePage.getInitialType()), true);
        super.performDefaults();
    }

    public boolean performOk() {
        this.outputBlock.saveColumnSettings();
        final boolean[] ok = new boolean[1];
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        XSLTRuntime.saveOutputPropertyPreferences((Map)OutputPreferencePage.this.typePropertyMap, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        XSLDebugUIPlugin.log(e);
                    }
                    ok[0] = !monitor.isCanceled();
                }
            };
            XSLDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            XSLDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            XSLDebugUIPlugin.log(e);
        }
        return ok[0];
    }
}

