/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.IStylesheetEntriesChangedListener;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetContentProvider;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class StylesheetViewer
extends TableViewer {
    private final ListenerList listenerList = new ListenerList();

    public StylesheetViewer(Composite parent) {
        super(parent);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (StylesheetViewer.this.updateSelection(2, (IStructuredSelection)StylesheetViewer.this.getSelection()) && event.character == '\u007f' && event.stateMask == 0) {
                    List selection = StylesheetViewer.this.getSelectionFromWidget();
                    StylesheetViewer.this.getStylesheetContentProvider().removeEntries(selection.toArray(new LaunchTransform[0]));
                    StylesheetViewer.this.notifyChanged();
                }
            }
        });
    }

    private StylesheetContentProvider getStylesheetContentProvider() {
        return (StylesheetContentProvider)super.getContentProvider();
    }

    public void setEntries(LaunchTransform[] transforms) {
        this.getStylesheetContentProvider().setEntries(transforms);
        this.notifyChanged();
    }

    public LaunchTransform[] getEntries() {
        return (LaunchTransform[])this.getStylesheetContentProvider().getElements(null);
    }

    public Shell getShell() {
        return this.getControl().getShell();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean updateSelection(int actionType, IStructuredSelection selection) {
        switch (actionType) {
            case 1: {
                return true;
            }
        }
        return selection.size() > 0;
    }

    public IStructuredSelection getSelectedEntries() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        return selection;
    }

    public void addTransforms(LaunchTransform[] res) {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        Object beforeElement = sel.getFirstElement();
        if (this.getEntries().length > 1 && beforeElement == null) {
            beforeElement = this.getEntries()[this.getEntries().length - 1];
        }
        this.getStylesheetContentProvider().addEntries(res, beforeElement);
        this.notifyChanged();
    }

    public void removeEntries(LaunchTransform[] entries) {
        this.getStylesheetContentProvider().removeEntries(entries);
        this.notifyChanged();
    }

    public void addEntriesChangedListener(IStylesheetEntriesChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeEntriesChangedListener(IStylesheetEntriesChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    private void notifyChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ((IStylesheetEntriesChangedListener)element).entriesChanged(this);
            ++n2;
        }
    }
}

