/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.output;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xsl.internal.debug.ui.ResourceSelectionBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.MainTabMessages;

public class OutputFileBlock
extends ResourceSelectionBlock {
    public static final String OUTPUT_METHOD_DEFAULT = "<Default>";
    public static final String OUTPUT_METHOD_XML = "xml";
    public static final String OUTPUT_METHOD_XHTML = "xhtml";
    public static final String OUTPUT_METHOD_HTML = "html";
    public static final String OUTPUT_METHOD_TEXT = "text";
    public static final String[] OUTPUT_METHODS = new String[]{"<Default>", "xml", "xhtml", "html", "text"};
    private Button openFileCheckButton;
    private ComboViewer methodViewer;
    private String inputFilename;

    public OutputFileBlock() {
        super(1, true, true, false);
    }

    protected String getMessage(int type) {
        switch (type) {
            case 1: {
                return MainTabMessages.OutputFOFileBlock_DIRECTORY_NOT_SPECIFIED;
            }
            case 2: {
                return MainTabMessages.OutputFOFileBlock_DIRECTORY_DOES_NOT_EXIST;
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return MainTabMessages.OutputFileBlock_0;
            }
            case 5: {
                return MainTabMessages.OutputFOFileBlock_OTHER_RADIO;
            }
            case 6: {
                return MainTabMessages.OutputFOFileBlock_DIALOG_MESSAGE;
            }
            case 7: {
                return MainTabMessages.OutputFOFileBlock_WORKSPACE_DIALOG_MESSAGE;
            }
            case 8: {
                return MainTabMessages.OutputFOFileBlock_VARIABLES_BUTTON;
            }
            case 9: {
                return MainTabMessages.OutputFOFileBlock_FILE_SYSTEM_BUTTON;
            }
            case 10: {
                return MainTabMessages.OutputFOFileBlock_WORKSPACE_BUTTON;
            }
            case 11: {
                return MainTabMessages.OutputFOFileBlock_WORKSPACE_DIALOG_TITLE;
            }
        }
        return "" + type;
    }

    protected void setDefaultResource() {
    }

    protected void createContents(Composite parent) {
        this.fileLabel = MainTabMessages.OutputFileBlock_7;
        this.createCheckboxAndText(parent);
        this.createButtons(parent);
    }

    protected void createButtons(Composite parent) {
        this.openFileCheckButton = this.createCheckButton(parent, MainTabMessages.OutputFileBlock_8);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 1;
        this.openFileCheckButton.setLayoutData((Object)gd);
        this.openFileCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputFileBlock.this.updateLaunchConfigurationDialog();
            }
        });
        Composite buttonComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(128);
        gd.horizontalSpan = 1;
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(parent.getFont());
        this.fWorkspaceButton = this.createPushButton(buttonComp, this.getMessage(10), null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, this.getMessage(9), null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.fVariablesButton = this.createPushButton(buttonComp, this.getMessage(8), null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.widgetListener);
    }

    public String getName() {
        return MainTabMessages.OutputFileBlock_9;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.inputFilename = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", "");
            this.updateDefaultOutputFile();
            boolean useDefault = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
            this.useDefaultCheckButton.setSelection(useDefault);
            this.outputFile = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILE", this.defaultOutputFile);
            this.updateResourceText(useDefault);
            boolean openFileOnCompletion = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
            this.openFileCheckButton.setSelection(openFileOnCompletion);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean useDefault = this.useDefaultCheckButton.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", useDefault);
        String outputFile = this.resourceText.getText();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILE", outputFile);
        boolean openFileOnCompletion = this.openFileCheckButton.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", openFileOnCompletion);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILE", "");
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_METHOD", null);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
    }

    private void updateDefaultOutputFile() {
        String method = OUTPUT_METHOD_XML;
        if (this.methodViewer != null) {
            method = (String)((IStructuredSelection)this.methodViewer.getSelection()).getFirstElement();
        }
        if (OUTPUT_METHOD_DEFAULT.equals(method)) {
            method = OUTPUT_METHOD_XML;
        }
        String file = this.inputFilename;
        int index = this.inputFilename.lastIndexOf(46);
        if (index != -1) {
            file = this.inputFilename.substring(0, index);
        }
        file = String.valueOf(file) + ".out." + method;
        if (this.inputFilename.trim().endsWith("}")) {
            file = String.valueOf(file) + "}";
        }
        this.defaultOutputFile = file;
    }
}

