/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.FeaturesPreferencePage;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.Messages;
import org.eclipse.wst.xsl.launching.IFeature;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.LaunchFeatures;

public class FeaturesBlock
extends AbstractTableBlock {
    private Table table;
    private TableViewer tViewer;
    private Text descriptionText;
    private IProcessorType processorType;
    private Button useFeaturesFromPreferencesRadio;
    private LaunchFeatures launchFeatures;
    private LaunchFeatures featuresFromPreferences;
    private Button changePreferences;
    private final Map<IProcessorType, LaunchFeatures> processorFeatures = new HashMap<IProcessorType, LaunchFeatures>();
    private Button useSpecificFeaturesRadio;

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.debug.ui.FEATURES_LAUNCH_BLOCK";
    }

    protected Table getTable() {
        return this.table;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(this.getName());
        GridData gd = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.setControl((Control)group);
        this.useFeaturesFromPreferencesRadio = new Button((Composite)group, 16);
        gd = new GridData(16384, 0x1000000, false, false);
        this.useFeaturesFromPreferencesRadio.setLayoutData((Object)gd);
        this.useFeaturesFromPreferencesRadio.setText(Messages.getString("FeaturesBlock.0"));
        this.useFeaturesFromPreferencesRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FeaturesBlock.this.handleUseFeaturesFromPreferences(true);
                FeaturesBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.changePreferences = new Button((Composite)group, 8);
        this.changePreferences.setText(Messages.getString("FeaturesBlock.1"));
        gd = new GridData(131072, 0x1000000, false, false);
        this.changePreferences.setLayoutData((Object)gd);
        this.changePreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeaturesPreferencePage page = new FeaturesPreferencePage();
                XSLDebugUIPlugin.showPreferencePage("org.eclipse.wst.xsl.debug.ui.page1", (IPreferencePage)page);
                FeaturesBlock.this.handleUseFeaturesFromPreferences(true);
            }
        });
        this.useSpecificFeaturesRadio = new Button((Composite)group, 16);
        gd = new GridData(16384, 0x1000000, false, false);
        this.useSpecificFeaturesRadio.setLayoutData((Object)gd);
        this.useSpecificFeaturesRadio.setText(Messages.getString("FeaturesBlock.3"));
        this.useSpecificFeaturesRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FeaturesBlock.this.handleUseFeaturesFromPreferences(false);
                FeaturesBlock.this.updateLaunchConfigurationDialog();
            }
        });
        new Label((Composite)group, 0);
        this.table = new Table((Composite)group, 68096);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 450;
        gd.horizontalSpan = 2;
        this.table.setLayoutData((Object)gd);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn c1 = new TableColumn(this.table, 0);
        c1.setWidth(150);
        c1.setResizable(true);
        c1.setText(Messages.getString("FeaturesBlock.4"));
        TableColumn c2 = new TableColumn(this.table, 0);
        c2.setWidth(50);
        c2.setResizable(true);
        c2.setText(Messages.getString("FeaturesBlock.5"));
        TableColumn c3 = new TableColumn(this.table, 0);
        c3.setWidth(250);
        c3.setResizable(true);
        c3.setText(Messages.getString("FeaturesBlock.6"));
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Set<?> typedFeatures;

            public Object[] getElements(Object inputElement) {
                return this.typedFeatures.toArray(new LaunchAttribute[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.typedFeatures = (Set)newInput;
            }
        });
        this.tViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                LaunchAttribute tv = (LaunchAttribute)element;
                switch (columnIndex) {
                    case 0: {
                        return this.removeURI(tv.uri);
                    }
                    case 1: {
                        return tv.type;
                    }
                    case 2: {
                        String value = tv.value;
                        return value == null ? "" : value;
                    }
                }
                return "!!";
            }

            private String removeURI(String uri) {
                int index = uri.lastIndexOf(47);
                if (index > 0) {
                    return uri.substring(index + 1);
                }
                return uri;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tViewer.setColumnProperties(new String[]{Messages.getString("FeaturesBlock.9"), Messages.getString("FeaturesBlock.10"), Messages.getString("FeaturesBlock.11")});
        this.tViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return Messages.getString("FeaturesBlock.12").equals(property);
            }

            public Object getValue(Object element, String property) {
                LaunchAttribute tv = (LaunchAttribute)element;
                return tv.value == null ? "" : tv.value;
            }

            public void modify(Object element, String property, Object value) {
                Item item = (Item)element;
                LaunchAttribute tv = (LaunchAttribute)item.getData();
                if (value == null || "".equals(value)) {
                    FeaturesBlock.this.launchFeatures.removeFeature(tv.uri);
                } else {
                    tv.setValue((String)value);
                }
                FeaturesBlock.this.tViewer.update((Object)tv, null);
                FeaturesBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.tViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LaunchAttribute a1 = (LaunchAttribute)e1;
                LaunchAttribute a2 = (LaunchAttribute)e2;
                return a1.uri.compareTo(a2.uri);
            }
        });
        TextCellEditor editor = new TextCellEditor((Composite)this.table);
        editor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                return null;
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = editor;
        CellEditor[] editors = cellEditorArray;
        this.tViewer.setCellEditors(editors);
        this.tViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LaunchAttribute tv = (LaunchAttribute)selection.getFirstElement();
                String text = null;
                if (tv != null) {
                    IFeature[] features;
                    IFeature feature = null;
                    IFeature[] iFeatureArray = features = FeaturesBlock.this.processorType.getFeatures();
                    int n = features.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFeature f = iFeatureArray[n2];
                        if (f.getURI().equals(tv.uri)) {
                            feature = f;
                            break;
                        }
                        ++n2;
                    }
                    text = feature == null ? null : feature.getDescription();
                }
                FeaturesBlock.this.descriptionText.setText(text == null ? "" : text);
            }
        });
        this.descriptionText = new Text((Composite)group, 2632);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 3;
        gd.heightHint = 50;
        this.descriptionText.setLayoutData((Object)gd);
        this.restoreColumnSettings();
    }

    private void handleUseFeaturesFromPreferences(boolean selected) {
        this.changePreferences.setEnabled(selected);
        this.table.setEnabled(!selected);
        if (selected) {
            this.launchFeatures = this.initializeFeaturesFromPreferences();
        } else {
            this.launchFeatures = this.processorFeatures.get(this.processorType);
            if (this.launchFeatures == null) {
                this.launchFeatures = new LaunchFeatures();
                this.processorFeatures.put(this.processorType, this.launchFeatures);
                int i = 0;
                while (i < this.processorType.getFeatures().length) {
                    IFeature feature = this.processorType.getFeatures()[i];
                    LaunchAttribute att = new LaunchAttribute(feature.getURI(), feature.getType(), null);
                    this.launchFeatures.addFeature(att);
                    ++i;
                }
            }
        }
        this.tViewer.setInput((Object)this.launchFeatures.getFeatures());
    }

    protected void setProcessorType(IProcessorType processorType) {
        if (processorType == this.processorType) {
            return;
        }
        this.processorType = processorType;
        this.handleUseFeaturesFromPreferences(this.useFeaturesFromPreferencesRadio.getSelection());
    }

    public String getName() {
        return Messages.getString("FeaturesBlock.16");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_FEATURES_FROM_PREFERENCES", true);
    }

    private LaunchFeatures initializeFeaturesFromPreferences() {
        LaunchFeatures featuresFromPreferences = new LaunchFeatures();
        IFeature[] features = this.processorType.getFeatures();
        Map values = this.processorType.getFeatureValues();
        IFeature[] iFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            featuresFromPreferences.addFeature(new LaunchAttribute(feature.getURI(), feature.getType(), (String)values.get(feature.getURI())));
            ++n2;
        }
        return featuresFromPreferences;
    }

    private void initializeFeaturesFromStorage(ILaunchConfiguration configuration) throws CoreException {
        IFeature[] features;
        LaunchFeatures launchFeatures = new LaunchFeatures();
        IFeature[] iFeatureArray = features = this.processorType.getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            launchFeatures.addFeature(new LaunchAttribute(feature.getURI(), feature.getType(), null));
            ++n2;
        }
        String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_FEATURES", null);
        if (s != null && s.length() > 0) {
            LaunchFeatures overrideFeatures = LaunchFeatures.fromXML((InputStream)new ByteArrayInputStream(s.getBytes()));
            launchFeatures.getFeatures().removeAll(overrideFeatures.getFeatures());
            launchFeatures.getFeatures().addAll(overrideFeatures.getFeatures());
        }
        this.processorFeatures.put(this.processorType, launchFeatures);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String processorId = null;
            boolean useDefaultProcessor = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
            processorId = useDefaultProcessor ? XSLTRuntime.getDefaultProcessor().getId() : configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR", "org.eclipse.wst.xsl.launching.jre.default");
            IProcessorInstall processor = XSLTRuntime.getProcessor((String)processorId);
            this.processorType = processor != null ? processor.getProcessorType() : XSLTRuntime.getDefaultProcessor().getProcessorType();
            this.featuresFromPreferences = this.initializeFeaturesFromPreferences();
            this.initializeFeaturesFromStorage(configuration);
            boolean useFeaturesFromPreferences = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_FEATURES_FROM_PREFERENCES", true);
            this.useSpecificFeaturesRadio.setSelection(!useFeaturesFromPreferences);
            this.useFeaturesFromPreferencesRadio.setSelection(useFeaturesFromPreferences);
            this.handleUseFeaturesFromPreferences(useFeaturesFromPreferences);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean useDefault = this.useFeaturesFromPreferencesRadio.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_FEATURES_FROM_PREFERENCES", useDefault);
        try {
            configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_FEATURES", useDefault ? null : this.launchFeatures.toXML());
        }
        catch (ParserConfigurationException e) {
            XSLDebugUIPlugin.log(e);
        }
        catch (IOException e) {
            XSLDebugUIPlugin.log(e);
        }
        catch (TransformerException e) {
            XSLDebugUIPlugin.log(e);
        }
    }
}

