/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.processor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.JarContentProvider;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.JarLabelProvider;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.ProcessorMessages;
import org.eclipse.wst.xsl.launching.IProcessorInstall;

public class ProcessorDetailsDialog
extends Dialog {
    private final IProcessorInstall install;

    public ProcessorDetailsDialog(Shell shell, IProcessorInstall install) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.install = install;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ProcessorMessages.ProcessorDetailsDialog_Title);
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createLabel(parent, ProcessorMessages.ProcessorDetailsDialog_installType);
        this.createLabel(parent, this.install.getProcessorType().getLabel());
        this.createLabel(parent, ProcessorMessages.ProcessorDetailsDialog_installName);
        this.createLabel(parent, this.install.getName());
        Label label = this.createLabel(parent, ProcessorMessages.ProcessorDetailsDialog_installClasspath);
        GridData gd = new GridData(34);
        label.setLayoutData((Object)gd);
        TableViewer libraryViewer = new TableViewer(parent);
        gd = new GridData(1808);
        gd.heightHint = 6;
        libraryViewer.getControl().setLayoutData((Object)gd);
        libraryViewer.setContentProvider((IContentProvider)new JarContentProvider());
        libraryViewer.setLabelProvider((IBaseLabelProvider)new JarLabelProvider());
        libraryViewer.setInput((Object)this.install);
        ProcessorDetailsDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected String getDialogSettingsSectionName() {
        return "XSL_DETAILS_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = XSLDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

