/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.invoker;

import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.wst.xsl.invoker.IProcessorInvoker;
import org.eclipse.wst.xsl.invoker.Messages;
import org.eclipse.wst.xsl.invoker.TransformationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXPSAXProcessorInvoker
implements IProcessorInvoker {
    private static final Log log;
    private XMLReader reader = this.createReader();
    private SAXTransformerFactory tFactory;
    private TransformerHandler th;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsl.invoker.JAXPSAXProcessorInvoker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected XMLReader createReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        return spf.newSAXParser().getXMLReader();
    }

    public void setFeatures(Map features) throws TransformerFactoryConfigurationError {
        this.createTransformerFactory();
        Iterator iter = features.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String uri = (String)entry.getKey();
            Object value = entry.getValue();
            log.info((Object)(String.valueOf(Messages.getString("JAXPSAXProcessorInvoker.0")) + uri + Messages.getString("JAXPSAXProcessorInvoker.1") + value));
            this.tFactory.setAttribute(uri, value);
        }
    }

    protected TransformerFactory createTransformerFactory() {
        this.tFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.tFactory.setErrorListener(new ErrorListener(){

            public void error(TransformerException exception) throws TransformerException {
                log.error((Object)exception.getMessageAndLocation());
            }

            public void fatalError(TransformerException exception) throws TransformerException {
                log.error((Object)exception.getMessageAndLocation(), (Throwable)exception);
                throw exception;
            }

            public void warning(TransformerException exception) throws TransformerException {
                log.warn((Object)exception.getMessageAndLocation());
            }
        });
        return this.tFactory;
    }

    public void addStylesheet(URL stylesheet, Map parameters, Properties outputProperties, URIResolver resolver) throws TransformerConfigurationException {
        InputSource inputsource = new InputSource(stylesheet.toString());
        SAXSource source = new SAXSource(inputsource);
        this.addStylesheet(source, resolver, parameters, outputProperties);
    }

    protected Transformer addStylesheet(Source source, URIResolver resolver, Map parameters, Properties outputProperties) throws TransformerConfigurationException {
        if (this.tFactory == null) {
            this.createTransformerFactory();
        }
        TransformerHandler newTh = this.tFactory.newTransformerHandler(source);
        Transformer transformer = newTh.getTransformer();
        if (resolver != null) {
            transformer.setURIResolver(resolver);
        }
        if (parameters != null) {
            Iterator iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                log.info((Object)(String.valueOf(Messages.getString("JAXPSAXProcessorInvoker.2")) + name + Messages.getString("JAXPSAXProcessorInvoker.3") + value));
                transformer.setParameter(name, value);
            }
        }
        if (outputProperties != null) {
            StringBuffer sb = new StringBuffer();
            Iterator<Map.Entry<Object, Object>> iter = outputProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
            }
            if (outputProperties.size() > 0) {
                log.info((Object)(String.valueOf(Messages.getString("JAXPSAXProcessorInvoker.6")) + sb.toString()));
                transformer.setOutputProperties(outputProperties);
            }
        }
        if (this.th != null) {
            this.th.setResult(new SAXResult(newTh));
        } else {
            this.reader.setContentHandler(newTh);
        }
        this.th = newTh;
        return this.th.getTransformer();
    }

    public void transform(URL sourceURL, Result res) throws TransformationException {
        this.transform(new InputSource(sourceURL.toExternalForm()), res);
    }

    public void transform(InputSource inputsource, Result res) throws TransformationException {
        try {
            if (this.th == null) {
                SAXSource saxSource;
                Source src = saxSource = new SAXSource(inputsource);
                String media = null;
                String title = null;
                String charset = null;
                while ((src = this.tFactory.getAssociatedStylesheet(src, media, title, charset)) != null) {
                    this.addStylesheet(saxSource, null, Collections.EMPTY_MAP, new Properties());
                }
                throw new TransformationException(String.valueOf(Messages.getString("JAXPSAXProcessorInvoker.7")) + inputsource.getSystemId());
            }
            this.th.setResult(res);
            log.info((Object)Messages.getString("JAXPSAXProcessorInvoker.8"));
            this.reader.parse(inputsource);
            log.info((Object)Messages.getString("JAXPSAXProcessorInvoker.9"));
        }
        catch (Exception e) {
            throw new TransformationException(e.getMessage(), e);
        }
    }
}

