/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.tests.testcase;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.wst.xsl.launching.tests.TestEnvironment;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLLaunchingTests
extends TestCase {
    private TestEnvironment _env;
    private IProject _testProject;

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._testProject = this._env.createProject("XSLTestProject");
    }

    public void testBuildConfig() throws CoreException, InterruptedException, ParserConfigurationException, SAXException, IOException {
        IPath folder = this._testProject.getFullPath();
        this._env.addFileFromResource(folder, "input.xml", "1-input.xml");
        this._env.addFileFromResource(folder, "transform.xsl", "1-transform.xsl");
        String launchXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<launchConfiguration type=\"org.eclipse.wst.xsl.launching.launchConfigurationType\">\r\n<stringAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE\" value=\"${workspace_loc:/XSLTestProject/input.xml}\"/>\r\n<booleanAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE\" value=\"false\"/>\r\n<stringAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILE\" value=\"${workspace_loc:/XSLTestProject}/output.xml\"/>\r\n<stringAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_OUTPUT_PROPERTIES\" value=\"&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#13;&#10;&lt;Properties&gt;&#13;&#10;&lt;Property name=&quot;indent&quot; value=&quot;yes&quot;/&gt;&#13;&#10;&lt;/Properties&gt;&#13;&#10;\"/>\r\n<stringAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_PIPELINE\" value=\"&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#13;&#10;&lt;Pipeline&gt;&#13;&#10;&lt;OutputProperties/&gt;&#13;&#10;&lt;Transform path=&quot;/XSLTestProject/transform.xsl&quot; pathType=&quot;resource&quot; uriResolver=&quot;&quot;&gt;&#13;&#10;&lt;Parameters/&gt;&#13;&#10;&lt;/Transform&gt;&#13;&#10;&lt;/Pipeline&gt;&#13;&#10;\"/>\r\n<stringAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_PROCESSOR\" value=\"org.eclipse.wst.xsl.launching.jre.default\"/>\r\n<booleanAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE\" value=\"false\"/>\r\n<booleanAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR\" value=\"false\"/>\r\n<booleanAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_USE_FEATURES_FROM_PREFERENCES\" value=\"true\"/>\r\n<booleanAttribute key=\"org.eclipse.wst.xsl.launching.ATTR_USE_PROPERTIES_FROM_PREFERENCES\" value=\"true\"/>\r\n<stringAttribute key=\"org.eclipse.wst.xsl.launching.INVOKER_DESCRIPTOR\" value=\"org.eclipse.wst.xsl.launching.jaxp.invoke\"/>\r\n</launchConfiguration>";
        String name = "launch" + (int)(Math.random() * 1000.0);
        this._env.addFile(folder, String.valueOf(name) + ".launch", launchXml);
        ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] allConfigs = mgr.getLaunchConfigurations();
        ILaunchConfiguration mine = null;
        boolean found = false;
        ILaunchConfiguration[] iLaunchConfigurationArray = allConfigs;
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration lc = iLaunchConfigurationArray[n2];
            if (lc.getName().equals(name)) {
                found = true;
                mine = lc;
                XSLLaunchingTests.assertEquals((String)"bad launch config type?", (String)"org.eclipse.wst.xsl.launching.launchConfigurationType", (String)lc.getType().getIdentifier());
                XSLLaunchingTests.assertEquals((String)"bad launch config plugin?", (String)"org.eclipse.wst.xsl.launching", (String)lc.getType().getPluginIdentifier());
            }
            ++n2;
        }
        XSLLaunchingTests.assertTrue((String)"expected to find the launch config we just added", (boolean)found);
        ILaunch launch = mine.launch("run", (IProgressMonitor)new NullProgressMonitor());
        int i = 0;
        while (i < 200 && !launch.isTerminated()) {
            System.out.println("waiting");
            Thread.sleep(100L);
            ++i;
        }
        if (!launch.isTerminated()) {
            System.out.println("Got tired of waiting, terminating");
            launch.terminate();
        }
        this._testProject.refreshLocal(2, null);
        IFile output = this._testProject.getFile("output.xml");
        Document doc = XSLLaunchingTests.parseXml(output.getContents(true));
        XSLLaunchingTests.assertEquals((String)"root-out", (String)doc.getDocumentElement().getNodeName());
    }

    public void testNothing() {
    }

    private static Document parseXml(InputStream contents) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(contents);
    }

    protected void tearDown() throws Exception {
        this._env.dispose();
        super.tearDown();
    }
}

