/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.wst.xsl.internal.launching.Messages;
import org.eclipse.wst.xsl.launching.IFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feature
implements IFeature,
Comparable<Object> {
    private final String uri;
    private final String description;
    private final String type;

    public Feature(String uri, String type, String description) {
        this.uri = uri;
        this.type = type;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public IStatus validateValue(String value) {
        Status status = null;
        if ("boolean".equals(this.type)) {
            boolean valid;
            boolean bl = valid = "true".equals(value) || "false".equals(value);
            if (!valid) {
                status = new Status(4, "org.eclipse.wst.xsl.launching", 0, Messages.getString("Feature.2"), null);
            }
        } else if ("int".equals(this.type)) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                status = new Status(4, "org.eclipse.wst.xsl.launching", 0, Messages.getString("Feature.1"), null);
            }
        } else if ("double".equals(this.type)) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                status = new Status(4, "org.eclipse.wst.xsl.launching", 0, Messages.getString("Feature.0"), null);
            }
        } else if ("float".equals(this.type)) {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                status = new Status(4, "org.eclipse.wst.xsl.launching", 0, Messages.getString("Feature.5"), null);
            }
        } else if ("class".equals(this.type) || "object".equals(this.type)) {
            status = JavaConventions.validateJavaTypeName((String)value);
        }
        return status;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof IFeature) {
            IFeature f = (IFeature)o;
            return f.getURI().compareTo(this.getURI());
        }
        return 0;
    }
}

