/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.launching.model.IXSLDebugTarget;
import org.eclipse.wst.xsl.launching.model.Messages;
import org.eclipse.wst.xsl.launching.model.XSLDebugElement;
import org.eclipse.wst.xsl.launching.model.XSLThread;
import org.eclipse.wst.xsl.launching.model.XSLVariable;

public class XSLStackFrame
extends XSLDebugElement
implements IStackFrame {
    private final XSLThread xslThread;
    private int id;
    private String name;
    private int lineNumber;
    private String xslFileName;
    private IVariable[] variables;

    public XSLStackFrame(XSLThread thread, String data, int index) {
        super(thread.getDebugTarget());
        this.xslThread = thread;
        this.init(data, (IXSLDebugTarget)thread.getDebugTarget());
    }

    private void init(String data, IXSLDebugTarget debugTarget) {
        String[] strings = data.split("\\|");
        String fileName = strings[0];
        try {
            int theIndex;
            URL url = new URL(fileName);
            Path p = new Path(url.getFile());
            this.xslFileName = new Path(fileName).lastSegment();
            String idString = strings[1];
            this.id = Integer.parseInt(idString);
            String pc = strings[2];
            this.lineNumber = Integer.parseInt(pc);
            String safename = strings[3];
            while ((theIndex = safename.indexOf("%@_PIPE_@%")) != -1) {
                safename = String.valueOf(safename.substring(0, theIndex)) + "|" + safename.substring(theIndex + "%@_PIPE_@%".length(), safename.length());
            }
            this.name = String.valueOf(p.lastSegment()) + " " + safename;
            this.variables = new XSLVariable[strings.length - 4];
            int i = 0;
            while (i < this.variables.length) {
                int varId = Integer.parseInt(strings[i + 4]);
                try {
                    XSLVariable var = debugTarget.getVariable(varId);
                    this.variables[i] = var;
                }
                catch (DebugException e) {
                    LaunchingPlugin.log((CoreException)((Object)e));
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            LaunchingPlugin.log(e);
        }
    }

    public IThread getThread() {
        return this.xslThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return String.valueOf(this.name) + Messages.getString("XSLStackFrame.5") + this.lineNumber;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.xslFileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XSLStackFrame) {
            XSLStackFrame sf = (XSLStackFrame)((Object)obj);
            return sf.id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.id;
    }

    protected int getIdentifier() {
        return this.id;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setVariables(IVariable[] variables) {
        this.variables = variables;
    }
}

