/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.templates.ElemCallTemplate;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.utils.QName;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPath;
import org.eclipse.wst.xsl.debugger.StyleFrame;
import org.eclipse.wst.xsl.xalan.debugger.XalanRootStyleFrame;
import org.eclipse.wst.xsl.xalan.debugger.XalanVariable;
import org.w3c.dom.Node;

public class XalanStyleFrame
extends StyleFrame {
    private static final Log log;
    private final Map varNames;
    private final Stack eventStack = new Stack();
    final TracerEvent event;
    private int currentLine;
    private XalanRootStyleFrame rootStyleFrame;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsl.xalan.debugger.XalanStyleFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public XalanStyleFrame(StyleFrame parent, TracerEvent event) {
        super(parent);
        this.event = event;
        this.varNames = parent != null ? new HashMap(((XalanStyleFrame)parent).varNames) : new HashMap();
        this.pushElement(event);
        this.findRootStyleFrame();
    }

    private void findRootStyleFrame() {
        XalanStyleFrame frame = this;
        do {
            if (!(frame instanceof XalanRootStyleFrame)) continue;
            this.rootStyleFrame = (XalanRootStyleFrame)frame;
        } while ((frame = (XalanStyleFrame)frame.getParent()) != null);
    }

    public String getFilename() {
        return this.event.m_styleNode.getStylesheet().getSystemId();
    }

    public String getName() {
        ElemCallTemplate et;
        QName q;
        String name = this.event.m_styleNode.getNodeName();
        if (this.event.m_styleNode instanceof ElemTemplate) {
            XPath xp;
            ElemTemplate et2 = (ElemTemplate)this.event.m_styleNode;
            QName q2 = et2.getName();
            if (q2 != null) {
                name = String.valueOf(name) + " name=\"" + q2.getLocalName() + "\"";
            }
            if ((xp = et2.getMatch()) != null) {
                name = String.valueOf(name) + " match=\"" + xp.getPatternString() + "\"";
            }
        } else if (this.event.m_styleNode instanceof ElemCallTemplate && (q = (et = (ElemCallTemplate)this.event.m_styleNode).getName()) != null) {
            name = String.valueOf(name) + " name=\"" + q.getLocalName() + "\"";
        }
        return name;
    }

    public List getVariableStack() {
        ArrayList vars = new ArrayList();
        vars.addAll(this.getLocals());
        vars.addAll(this.getGlobals());
        return vars;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void pushElement(TracerEvent e) {
        this.currentLine = e.m_styleNode.getLineNumber();
        this.eventStack.push(e);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pushed element " + TracerEvent.printNode((Node)e.m_styleNode) + " at line " + this.currentLine));
        }
    }

    public TracerEvent popElement() {
        TracerEvent e = (TracerEvent)this.eventStack.pop();
        this.currentLine = e.m_styleNode.getEndLineNumber();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Popped element " + TracerEvent.printNode((Node)e.m_styleNode) + " at line " + this.currentLine));
        }
        ElemTemplateElement element = e.m_styleNode;
        String name = element.getNodeName();
        log.debug((Object)(" name " + name));
        if (name.equals("param") || name.equals("variable")) {
            this.addVariable((ElemVariable)e.m_styleNode);
        }
        return e;
    }

    public TracerEvent peekElement() {
        if (this.eventStack.isEmpty()) {
            return null;
        }
        return (TracerEvent)this.eventStack.peek();
    }

    private void addVariable(ElemVariable variable) {
        String scope = variable.getIsTopLevel() ? "G" : "L";
        VariableStack vs = this.event.m_processor.getXPathContext().getVarStack();
        XalanVariable xvar = new XalanVariable(this, vs, scope, variable.getIndex(), variable);
        this.rootStyleFrame.addVariable(xvar);
        this.varNames.put(variable.getName(), xvar);
    }

    private List getLocals() {
        ArrayList locals = new ArrayList(this.varNames.values());
        Collections.sort(locals);
        return new ArrayList(this.varNames.values());
    }

    protected List getGlobals() {
        return this.rootStyleFrame.getGlobals();
    }

    public String getSourceFilename() {
        SourceLocator locator = this.getSourceLocator();
        if (locator != null) {
            return locator.getSystemId();
        }
        return "";
    }

    public int getSourceCurrentLine() {
        SourceLocator locator = this.getSourceLocator();
        if (locator != null) {
            return locator.getLineNumber();
        }
        return 0;
    }

    private SourceLocator getSourceLocator() {
        Node sourceNode = this.event.m_sourceNode;
        if (sourceNode instanceof DTMNodeProxy) {
            int nodeHandler = ((DTMNodeProxy)sourceNode).getDTMNodeNumber();
            return ((DTMNodeProxy)sourceNode).getDTM().getSourceLocatorFor(nodeHandler);
        }
        return null;
    }
}

