/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.internal.launching.FeaturePreferences;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.OutputPropertyPreferences;
import org.eclipse.wst.xsl.internal.launching.ProcessorType;
import org.eclipse.wst.xsl.internal.launching.registry.ProcessorTypeRegistryReader;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.osgi.framework.Bundle;

public class ProcessorTypeRegistry {
    protected static final String DESC_SUFFIX = ".DESC";
    protected static final String TYPE_SUFFIX = ".TYPE";
    private final List<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
    private IProcessorType[] installTypes;

    public ProcessorTypeRegistry() {
        ProcessorTypeRegistryReader registryReader = new ProcessorTypeRegistryReader();
        registryReader.addConfigs(this);
    }

    public IProcessorType[] getProcessorTypes() {
        if (this.installTypes == null) {
            ArrayList<ProcessorType> types = new ArrayList<ProcessorType>();
            String featureXMLString = LaunchingPlugin.getDefault().getPluginPreferences().getString("PREF_FEATURE_XML");
            FeaturePreferences prefs = null;
            if (featureXMLString.length() > 0) {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(featureXMLString.getBytes());
                    prefs = FeaturePreferences.fromXML(inputStream);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            String propXMLString = LaunchingPlugin.getDefault().getPluginPreferences().getString("PREF_OUTPUT_PROPERTIES_XML");
            OutputPropertyPreferences outputprefs = null;
            if (propXMLString.length() > 0) {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(propXMLString.getBytes());
                    outputprefs = OutputPropertyPreferences.fromXML(inputStream);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            for (IConfigurationElement element : this.elements) {
                String id = element.getAttribute("id");
                String label = element.getAttribute("label");
                String transFactoryName = element.getAttribute("transformerFactory");
                HashMap<String, String> featureValues = new HashMap<String, String>();
                Properties propertyValues = new Properties();
                if (prefs != null && prefs.getFeaturesValues(id) != null) {
                    featureValues.putAll(prefs.getFeaturesValues(id));
                }
                if (outputprefs != null && outputprefs.getOutputPropertyValues(id) != null) {
                    propertyValues.putAll((Map<?, ?>)outputprefs.getOutputPropertyValues(id));
                }
                String outputProperties = element.getAttribute("outputProperties");
                URL outputPropertiesURL = FileLocator.find((Bundle)Platform.getBundle((String)element.getContributor().getName()), (IPath)new Path(outputProperties), null);
                String featureProperties = element.getAttribute("featureProperties");
                URL featurePropertiesURL = FileLocator.find((Bundle)Platform.getBundle((String)element.getContributor().getName()), (IPath)new Path(featureProperties), null);
                types.add(new ProcessorType(id, label, featurePropertiesURL, outputPropertiesURL, featureValues, propertyValues, transFactoryName));
            }
            this.installTypes = types.toArray(new IProcessorType[0]);
        }
        return this.installTypes;
    }

    public IProcessorType[] getProcessorTypesExclJREDefault() {
        IProcessorType[] installTypes = this.getProcessorTypes();
        ArrayList<IProcessorType> exclTypes = new ArrayList<IProcessorType>(installTypes.length - 1);
        IProcessorType[] iProcessorTypeArray = installTypes;
        int n = installTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            if (!type.isJREDefault()) {
                exclTypes.add(type);
            }
            ++n2;
        }
        return exclTypes.toArray(new IProcessorType[0]);
    }

    public void addType(IConfigurationElement element) {
        this.elements.add(element);
    }

    public IProcessorType getProcessorType(String id) {
        IProcessorType[] installTypes;
        IProcessorType[] iProcessorTypeArray = installTypes = this.getProcessorTypes();
        int n = installTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            if (type.getId().equals(id)) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

