/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.internal.launching.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchProperties {
    private final Map<String, String> properties = new HashMap<String, String>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public String toXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element featuresEl = doc.createElement("Properties");
        doc.appendChild(featuresEl);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            Element featureEl = doc.createElement("Property");
            featureEl.setAttribute("name", name);
            featureEl.setAttribute("value", value);
            featuresEl.appendChild(featureEl);
        }
        return PreferenceUtil.serializeDocument(doc);
    }

    public static LaunchProperties fromXML(InputStream inputStream) throws CoreException {
        Document doc = PreferenceUtil.getDocument(inputStream);
        LaunchProperties pdef = new LaunchProperties();
        Element featuresEl = doc.getDocumentElement();
        NodeList featureEls = featuresEl.getElementsByTagName("Property");
        int i = 0;
        while (i < featureEls.getLength()) {
            Element featureEl = (Element)featureEls.item(i);
            String name = featureEl.getAttribute("name");
            String value = featureEl.getAttribute("value");
            pdef.setProperty(name, value);
            ++i;
        }
        return pdef;
    }
}

