/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.breakpoint;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;
import org.eclipse.wst.xsl.internal.debug.ui.breakpoint.Messages;
import org.eclipse.wst.xsl.launching.model.XSLLineBreakpoint;

public class XSLBreakpointProvider
implements IBreakpointProvider,
IExecutableExtension {
    public IStatus addBreakpoint(IDocument document, IEditorInput input, int editorLineNumber, int offset) throws CoreException {
        int pos = this.getValidPosition(document, editorLineNumber);
        Status status = null;
        if (pos >= 0) {
            IResource res = this.getResourceFromInput(input);
            if (res != null) {
                XSLLineBreakpoint point;
                boolean add = true;
                if (add && (point = new XSLLineBreakpoint(res, editorLineNumber, pos, pos)) == null) {
                    status = new Status(4, "org.eclipse.wst.xsl.debug.ui", 4, Messages.XSLBreakpointProvider_0, null);
                }
            } else if (input instanceof IStorageEditorInput) {
                res = ResourcesPlugin.getWorkspace().getRoot();
                String id = input.getName();
                if (input instanceof IStorageEditorInput && ((IStorageEditorInput)input).getStorage() != null && ((IStorageEditorInput)input).getStorage().getFullPath() != null) {
                    id = ((IStorageEditorInput)input).getStorage().getFullPath().toString();
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", id);
                XSLLineBreakpoint point = new XSLLineBreakpoint(res, editorLineNumber, pos, pos);
                if (point == null) {
                    status = new Status(4, "org.eclipse.wst.xsl.debug.ui", 4, Messages.XSLBreakpointProvider_0, null);
                }
            }
        }
        if (status == null) {
            status = new Status(0, "org.eclipse.wst.xsl.debug.ui", 0, "JSPUIMessages.OK", null);
        }
        return status;
    }

    public IResource getResource(IEditorInput input) {
        return this.getResourceFromInput(input);
    }

    private IResource getResourceFromInput(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    private int getValidPosition(IDocument idoc, int editorLineNumber) {
        int result = -1;
        if (idoc != null) {
            int startOffset = 0;
            int endOffset = 0;
            try {
                IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                startOffset = line.getOffset();
                endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                String lineText = idoc.get(startOffset, endOffset - startOffset).trim();
                if (lineText.trim().equals("") || lineText.startsWith("<?")) {
                    result = -1;
                } else {
                    ITypedRegion[] partitions = null;
                    partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                    int i = 0;
                    while (i < partitions.length) {
                        result = partitions[i].getOffset();
                        ++i;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                result = -1;
            }
        }
        return result;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tools) {
    }
}

