/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.xsl.ui.internal.preferences.AbstractXSLPreferencePage;

public class ValidationPreferencePage
extends AbstractXSLPreferencePage {
    private static final String[] ERRORS = new String[]{"Error", "Warning", "Ignore"};
    private static final int[] ERROR_VALUES;
    private static final Map<Integer, Integer> ERROR_MAP;
    private Text maxErrorsText;
    private Map<String, Combo> combos = new HashMap<String, Combo>();

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 1;
        ERROR_VALUES = nArray;
        ERROR_MAP = new HashMap<Integer, Integer>();
        ERROR_MAP.put(2, 0);
        ERROR_MAP.put(1, 1);
        ERROR_MAP.put(0, 2);
    }

    public ValidationPreferencePage() {
        this.setTitle("XSL Validation");
        this.setDescription("Configure validation preferences");
    }

    protected Composite createCommonContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        pageContent.setLayoutData((Object)new GridData(1808));
        pageContent.setExpandHorizontal(true);
        pageContent.setExpandVertical(true);
        Composite body = pageContent.getBody();
        body.setLayout((Layout)layout);
        this.createLabel(body, "Maximum number of errors reported per stylesheet:");
        this.maxErrorsText = this.createTextField(body);
        this.maxErrorsText.addModifyListener((ModifyListener)this);
        Composite twistie = this.createTwistie(body, "Imports and Includes", 2);
        this.createCombo(twistie, "Unresolved include/import:", "MISSING_INCLUDE");
        this.createCombo(twistie, "Circular references:", "CIRCULAR_REF");
        twistie = this.createTwistie(body, "Named Templates", 2);
        this.createCombo(twistie, "Template name conflicts:", "TEMPLATE_CONFLICT");
        this.createCombo(twistie, "Duplicate parameterw:", "DUPLICATE_PARAMETER");
        this.createCombo(twistie, "Parameter without name attribute:", "NAME_ATTRIBUTE_MISSING");
        this.createCombo(twistie, "Parameter with empty name attribute:", "NAME_ATTRIBUTE_EMPTY");
        twistie = this.createTwistie(body, "Template Calls", 2);
        this.createCombo(twistie, "Unresolved templates:", "CHECK_CALL_TEMPLATES");
        this.createCombo(twistie, "Missing parameters:", "MISSING_PARAM");
        this.createCombo(twistie, "Parameters without value:", "EMPTY_PARAM");
        twistie = this.createTwistie(body, "XPath Problems", 2);
        this.createCombo(twistie, "Incorrect XPath syntax:", "CHECK_XPATHS");
        return parent;
    }

    protected Combo createCombo(Composite parent, String label, String prefKey) {
        Combo combo = super.createCombo(parent, label, prefKey);
        combo.setItems(ERRORS);
        this.combos.put(prefKey, combo);
        return combo;
    }

    protected void initializeValues() {
        int maxErrors = this.getModelPreferences().getInt("MAX_ERRORS");
        this.maxErrorsText.setText(String.valueOf(maxErrors));
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int val = this.getModelPreferences().getInt(entry.getKey());
            entry.getValue().select(ERROR_MAP.get(val).intValue());
        }
    }

    protected void storeValues() {
        int maxErrors = Integer.parseInt(this.maxErrorsText.getText());
        this.getModelPreferences().setValue("MAX_ERRORS", maxErrors);
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int index = entry.getValue().getSelectionIndex();
            this.getModelPreferences().setValue(entry.getKey(), ERROR_VALUES[index]);
        }
    }

    protected void validateValues() {
        String errorMessage = null;
        try {
            int maxErrors = Integer.parseInt(this.maxErrorsText.getText());
            if (maxErrors < 0) {
                errorMessage = "Max errors must be a positive integer";
            }
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage = "Max errors must be a positive integer";
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }

    protected void performDefaults() {
        int maxErrors = this.getModelPreferences().getDefaultInt("MAX_ERRORS");
        this.maxErrorsText.setText(String.valueOf(maxErrors));
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int def = this.getModelPreferences().getDefaultInt(entry.getKey());
            entry.getValue().select(ERROR_MAP.get(def).intValue());
        }
        super.performDefaults();
    }
}

