/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.core.xpath.tests;

import junit.framework.TestCase;
import org.eclipse.wst.xml.xpath.core.internal.parser.XPathParser;

public class TestXPathCoreXPathParser
extends TestCase {
    protected String xpathSingleLine = "$linksFile='' and (normalize-space(translate($searchIncludedSchemas, 'TRUE', 'true'))='true' or normalize-space(translate($searchImportedSchemas, 'TRUE', 'true'))='true')";
    protected String xpathMultiLine = "$linksFile='' and\n(normalize-space(translate($searchIncludedSchemas, 'TRUE', 'true'))='true'\nor normalize-space(translate($searchImportedSchemas, 'TRUE', 'true'))='true')";
    protected String xpathPartial = "starts-with(, )";
    protected String xpathSpaceCheck = "  and starts-with('pre', )";

    public void testCoreXPathParser() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        parser = null;
        parser = new XPathParser(this.xpathMultiLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
    }

    public void testgetTokenStartOffset() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)2, (int)parser.getTokenStartOffset(1, 2));
    }

    public void testgetTokenStartOffset2() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)20, (int)parser.getTokenStartOffset(1, 20));
        TestXPathCoreXPathParser.assertEquals((String)"Unexpected token value:", (String)"normalize-space", (String)parser.getCurrentToken().image);
        TestXPathCoreXPathParser.assertEquals((String)"Expected Function normalize-space", (int)64, (int)parser.getCurrentToken().kind);
    }

    public void testgetTokenStartOffset3() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)15, (int)parser.getTokenStartOffset(1, 15));
        TestXPathCoreXPathParser.assertEquals((String)"Unexpected token value:", (String)"and", (String)parser.getCurrentToken().image);
        TestXPathCoreXPathParser.assertEquals((String)"Expected AND kind", (int)28, (int)parser.getCurrentToken().kind);
    }

    public void testgetTokenStartOffset4() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)19, (int)parser.getTokenStartOffset(1, 19));
        TestXPathCoreXPathParser.assertEquals((String)"Unexpected token value:", (String)"(", (String)parser.getCurrentToken().image);
    }

    public void testgetTokenStartOffset5() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)164, (int)parser.getTokenStartOffset(1, 167));
        TestXPathCoreXPathParser.assertEquals((String)"Unexpected token value:", (String)"'true'", (String)parser.getCurrentToken().image);
    }

    public void testgetTokenStartOffset6() {
        XPathParser parser = new XPathParser("self::");
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)7, (int)parser.getTokenStartOffset(1, 7));
    }

    public void testgetTokenStartOffsetNotEqual() {
        XPathParser parser = new XPathParser(this.xpathSingleLine);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertFalse((String)"Value of token offset is 1 should be 164:", (parser.getTokenStartOffset(1, 167) == 1 ? 1 : 0) != 0);
    }

    public void testXPathPartial() {
        XPathParser parser = new XPathParser(this.xpathPartial);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)13, (int)parser.getTokenStartOffset(1, 13));
    }

    public void testXPathSpaceCheck() {
        XPathParser parser = new XPathParser(this.xpathSpaceCheck);
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)2, (int)parser.getTokenStartOffset(1, 2));
    }

    public void testEmptyString() {
        XPathParser parser = new XPathParser("");
        TestXPathCoreXPathParser.assertNotNull((Object)parser);
        TestXPathCoreXPathParser.assertEquals((String)"Value of token offset is wrong:", (int)1, (int)parser.getTokenStartOffset(1, 1));
    }
}

