/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.core.xpath.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.Axis.Axis;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.Axis.impl.AxisFactoryImpl;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.DataTypes.DataTypes;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.DataTypes.Variable;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.DataTypes.impl.DataTypesFactoryImpl;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.Function.Argument;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.Function.Function;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.Function.Occurrence;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.Function.impl.FunctionFactoryImpl;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.XPath;
import org.eclipse.wst.xml.xpath.core.internal.model.XPath.impl.xpathFactoryImpl;

public class TestXPathModel
extends TestCase {
    public void testCreateXPathRoot() throws Exception {
        XPath xpath = new xpathFactoryImpl().createXPath();
        TestXPathModel.assertNotNull((String)"Failed to create xpath class", (Object)xpath);
    }

    public void testLoadXPathModel() throws Exception {
        BasicEList components = new BasicEList();
        XPath xpath = new xpathFactoryImpl().createXPath();
        Variable variable = new DataTypesFactoryImpl().createVariable();
        variable.setName("test");
        variable.setBeginColumn(1);
        variable.setEndColumn(4);
        variable.setBeginLineNumber(1);
        variable.setEndLineNumber(1);
        components.add((Object)variable);
        xpath.setComponents((EList)components);
        TestXPathModel.assertNotNull((String)"XPath Components array not set.", (Object)xpath.getComponentsList());
        EList xpathComp = xpath.getComponentsList();
        TestXPathModel.assertEquals((String)"Number of components not equal to 1.", (int)1, (int)xpathComp.size());
        if (!(xpathComp.get(0) instanceof Variable)) {
            Assert.fail((String)"Component that was not a variable.");
        }
        variable = (Variable)xpathComp.get(0);
        TestXPathModel.assertEquals((String)"Name does not equal test", (String)"test", (String)variable.getName());
        TestXPathModel.assertEquals((String)"Beginning Column Number not 1", (int)1, (int)variable.getBeginColumn());
        TestXPathModel.assertEquals((String)"Ending Column Number not 4", (int)4, (int)variable.getEndColumn());
        TestXPathModel.assertEquals((String)"Begining Line Number incorrect.", (int)1, (int)variable.getBeginLineNumber());
        TestXPathModel.assertEquals((String)"Ending Line Number incorrect.", (int)1, (int)variable.getEndLineNumber());
    }

    public void testFunctionNoArgs() {
        Function function = new FunctionFactoryImpl().createFunction();
        function.setName("true");
        function.setReturns(DataTypes.BOOLEAN);
        TestXPathModel.assertEquals((String)"Arguments greater than zero.", (int)0, (int)function.getArguments().length);
    }

    public void testFunctionWithStringArg() {
        FunctionFactoryImpl funcFactory = new FunctionFactoryImpl();
        Function function = funcFactory.createFunction();
        function.setName("lang");
        function.setReturns(DataTypes.BOOLEAN);
        Argument arg = funcFactory.createArgument();
        arg.setDataType(DataTypes.STRING.getName());
        arg.setRequired(Occurrence.YES);
        Argument[] args = new Argument[]{arg};
        function.setArguments(args);
        TestXPathModel.assertEquals((String)"Arguments not equal to 1", (int)1, (int)function.getArguments().length);
        arg = function.getArguments(0);
        TestXPathModel.assertEquals((String)"String argument not found.", (String)DataTypes.STRING.getName(), (String)arg.getDataType());
    }

    public void testFunctionWithTwoRequiredOneOptional() {
        FunctionFactoryImpl funcFactory = new FunctionFactoryImpl();
        Function function = funcFactory.createFunction();
        function.setName("concat");
        function.setReturns(DataTypes.STRING);
        Argument arg = funcFactory.createArgument();
        arg.setDataType(DataTypes.STRING.getName());
        arg.setRequired(Occurrence.YES);
        Argument arg2 = funcFactory.createArgument();
        arg2.setDataType(DataTypes.STRING.getName());
        arg2.setRequired(Occurrence.YES);
        Argument arg3 = funcFactory.createArgument();
        arg3.setDataType(DataTypes.STRING.getName());
        arg3.setRequired(Occurrence.NO);
        Argument[] args = new Argument[]{arg, arg2, arg3};
        function.setArguments(args);
        TestXPathModel.assertEquals((String)"Arguments not equal to 3", (int)3, (int)function.getArguments().length);
        arg = function.getArguments(0);
        TestXPathModel.assertEquals((String)"Arg1 String argument not found.", (String)DataTypes.STRING.getName(), (String)arg.getDataType());
        TestXPathModel.assertEquals((String)"Should be required.", (Object)Occurrence.YES, (Object)arg.getRequired());
        arg = function.getArguments(1);
        TestXPathModel.assertEquals((String)"Arg2 String argument not found.", (String)DataTypes.STRING.getName(), (String)arg.getDataType());
        TestXPathModel.assertEquals((String)"Should be required.", (Object)Occurrence.YES, (Object)arg.getRequired());
        arg = function.getArguments(2);
        TestXPathModel.assertEquals((String)"Arg3 String argument not found.", (String)DataTypes.STRING.getName(), (String)arg.getDataType());
        TestXPathModel.assertEquals((String)"Should be optional.", (Object)Occurrence.NO, (Object)arg.getRequired());
    }

    public void testCreateAXIS() throws Exception {
        Axis axis = new AxisFactoryImpl().createAxis();
        axis.setName("following-sibling");
        TestXPathModel.assertEquals((String)"following-sibling", (String)axis.getName());
    }
}

