/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xsl.internal.launching.PreferenceUtil;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchPipeline {
    private List<LaunchTransform> transformDefs = new ArrayList<LaunchTransform>();
    private final Properties outputProperties = new Properties();

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void addOutputProperty(String name, String value) {
        this.outputProperties.put(name, value);
    }

    public List<LaunchTransform> getTransformDefs() {
        return this.transformDefs;
    }

    public void setTransformDefs(List<LaunchTransform> transforms) {
        this.transformDefs = transforms;
    }

    public void addTransformDef(LaunchTransform tdef) {
        tdef.setPipeline(this);
        this.transformDefs.add(tdef);
    }

    public void removeTransformDef(LaunchTransform tdef) {
        this.transformDefs.remove(tdef);
    }

    public String toXML() throws CoreException {
        String xml = null;
        try {
            Document doc = PreferenceUtil.getDocument();
            Element rootEl = doc.createElement("Pipeline");
            doc.appendChild(rootEl);
            Element opEl = doc.createElement("OutputProperties");
            rootEl.appendChild(opEl);
            Iterator<Map.Entry<Object, Object>> iterator = this.outputProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> element;
                Map.Entry<Object, Object> entry = element = iterator.next();
                Element propEl = doc.createElement("Property");
                propEl.setAttribute("name", (String)entry.getKey());
                propEl.setAttribute("value", (String)entry.getValue());
                opEl.appendChild(propEl);
            }
            for (LaunchTransform tdef : this.transformDefs) {
                Element tdefEl = tdef.asXML(doc);
                rootEl.appendChild(tdefEl);
            }
            xml = PreferenceUtil.serializeDocument(doc);
        }
        catch (DOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 0, e.getMessage(), (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 0, e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 0, e.getMessage(), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.launching", 0, e.getMessage(), (Throwable)e));
        }
        return xml;
    }

    public static LaunchPipeline fromXML(InputStream inputStream) throws CoreException {
        int i;
        Document doc = PreferenceUtil.getDocument(inputStream);
        LaunchPipeline pdef = new LaunchPipeline();
        Element rootEl = doc.getDocumentElement();
        Element opEl = (Element)rootEl.getElementsByTagName("OutputProperties").item(0);
        if (opEl != null) {
            NodeList propEls = opEl.getElementsByTagName("Property");
            i = 0;
            while (i < propEls.getLength()) {
                Element propEl = (Element)propEls.item(i);
                String name = propEl.getAttribute("name");
                String value = propEl.getAttribute("value");
                pdef.addOutputProperty(name, value);
                ++i;
            }
        }
        NodeList transformEls = rootEl.getElementsByTagName("Transform");
        i = 0;
        while (i < transformEls.getLength()) {
            Element transformEl = (Element)transformEls.item(i);
            LaunchTransform tdef = LaunchTransform.fromXML(transformEl);
            pdef.addTransformDef(tdef);
            ++i;
        }
        return pdef;
    }
}

