/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.xpath.ui.views.XPathNavigator;
import org.osgi.framework.BundleContext;

public class XPathViewPlugin
extends AbstractUIPlugin
implements IPartListener2 {
    private static XPathViewPlugin plugin;
    private ResourceBundle resourceBundle;
    private TemplateStore fXPathTemplateStore;
    private ContributionContextTypeRegistry fXPathContextTypeRegistry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].getPartService().addPartListener((IPartListener2)this);
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].getPartService().removePartListener((IPartListener2)this);
            ++i;
        }
    }

    public static XPathViewPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return XPathViewPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void info(String message) {
        this.getLog().log((IStatus)new Status(1, XPathViewPlugin.getPluginId(), 0, message, null));
    }

    public void warn(String message) {
        this.getLog().log((IStatus)new Status(2, XPathViewPlugin.getPluginId(), 4, message, null));
    }

    public void log(String message, Throwable ex) {
        this.getLog().log((IStatus)new Status(4, XPathViewPlugin.getPluginId(), 4, "Error", ex));
    }

    public void log(Throwable ex) {
        this.log("Error", ex);
    }

    public static void throwCoreException(String message, Throwable t) throws CoreException {
        throw new CoreException((IStatus)new Status(4, XPathViewPlugin.getPluginId(), 4, message, t));
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = XPathViewPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        try {
            URL baseURL = this.getBundle().getEntry("/icons/");
            reg.put("refresh", ImageDescriptor.createFromURL((URL)new URL(baseURL, "refresh.gif")));
            reg.put("run", ImageDescriptor.createFromURL((URL)new URL(baseURL, "run.gif")));
        }
        catch (MalformedURLException e) {
            this.log(e);
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    private XPathNavigator getXPathNavigatorView(IWorkbenchPage page) {
        if (page == null) {
            return null;
        }
        IViewReference[] viewReferences = page.getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            IViewReference viewReference = viewReferences[i];
            if (viewReference.getView(false) instanceof XPathNavigator) {
                return (XPathNavigator)viewReference.getView(false);
            }
            ++i;
        }
        return null;
    }

    protected void updateXPathNavigatorView(IWorkbenchPartReference partRef) {
        XPathNavigator navigatorView = this.getXPathNavigatorView(partRef.getPage().getWorkbenchWindow().getActivePage());
        if (navigatorView != null) {
            navigatorView.update();
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.updateXPathNavigatorView(partRef);
    }

    public TemplateStore getXPathTemplateStore() {
        if (this.fXPathTemplateStore == null) {
            this.fXPathTemplateStore = new ContributionTemplateStore(this.getXPathTemplateContextRegistry(), this.getPreferenceStore(), "org.eclipse.wst.xml.xpath.ui.xpath_custom_templates");
            try {
                this.fXPathTemplateStore.load();
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return this.fXPathTemplateStore;
    }

    public ContextTypeRegistry getXPathTemplateContextRegistry() {
        if (this.fXPathContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("xsl_xpath");
            registry.addContextType("xpath_operator");
            registry.addContextType("xpath_axis");
            registry.addContextType("exslt_function");
            registry.addContextType("xpath_2");
            registry.addContextType("extension_function");
            this.fXPathContextTypeRegistry = registry;
        }
        return this.fXPathContextTypeRegistry;
    }
}

