/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.core.internal.model.XPath.Function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Occurrence implements Enumerator
{
    NO(0, "no", "no"),
    YES(1, "yes", "yes");

    public static final String copyright = " Copyright (c) 2008 Standards for Technology in Automotive Retail and others.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n\n Contributors:\n     David Carver - initial API and implementation";
    public static final int NO_VALUE = 0;
    public static final int YES_VALUE = 1;
    private static final Occurrence[] VALUES_ARRAY;
    public static final List<Occurrence> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Occurrence[]{NO, YES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Occurrence get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Occurrence result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Occurrence getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Occurrence result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Occurrence get(int value) {
        switch (value) {
            case 0: {
                return NO;
            }
            case 1: {
                return YES;
            }
        }
        return null;
    }

    private Occurrence(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

