/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetViewer;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStylesheetAction
extends SelectionListenerAction {
    public static final int DEFAULT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int MOVE = 3;
    private StylesheetViewer viewer;
    private Button button;
    private Shell shell;

    protected AbstractStylesheetAction(String text, StylesheetViewer viewer) {
        super(text);
        this.setViewer(viewer);
    }

    public void addTransforms(LaunchTransform[] res) {
        this.viewer.addTransforms(res);
    }

    public void setViewer(StylesheetViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.viewer = viewer;
        if (viewer != null) {
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.update();
        }
    }

    protected StylesheetViewer getViewer() {
        return this.viewer;
    }

    public void setButton(Button button) {
        this.button = button;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AbstractStylesheetAction.this.run();
            }
        });
        button.setEnabled(this.isEnabled());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }

    protected void update() {
        this.selectionChanged((IStructuredSelection)this.getViewer().getSelection());
    }

    protected Shell getShell() {
        if (this.shell == null) {
            this.shell = this.getViewer().getShell();
        }
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getViewer().updateSelection(this.getActionType(), selection);
    }

    protected int getActionType() {
        return 0;
    }

    protected List<?> getOrderedSelection() {
        List selection = ((IStructuredSelection)this.getViewer().getSelection()).toList();
        return selection;
    }

    protected List<LaunchTransform> getEntriesAsList() {
        LaunchPipeline lp = (LaunchPipeline)this.getViewer().getInput();
        return lp.getTransformDefs();
    }

    protected void setEntries(List<?> list) {
        this.getViewer().setEntries(list.toArray(new LaunchTransform[list.size()]));
    }

    protected boolean isIndexSelected(IStructuredSelection selection, int index) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator entries = selection.iterator();
        List<LaunchTransform> list = this.getEntriesAsList();
        while (entries.hasNext()) {
            Object next = entries.next();
            if (list.indexOf(next) != index) continue;
            return true;
        }
        return false;
    }
}

