/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.InstalledProcessorsBlock;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.ProcessorLibraryBlock;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.InstallStandin;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.ProcessorMessages;
import org.eclipse.wst.xsl.launching.IDebugger;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorJar;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;

public class AddProcessorDialog
extends StatusDialog {
    private final InstallStandin standinProcessor;
    private final IProcessorType[] processorTypes;
    private IProcessorType selectedProcessorType;
    private ComboViewer processorTypeField;
    private ProcessorLibraryBlock fLibraryBlock;
    private Text processorNameField;
    private final IStatus[] fStati;
    private int fPrevIndex = -1;
    private final InstalledProcessorsBlock block;
    private boolean adding;

    public AddProcessorDialog(InstalledProcessorsBlock block, Shell parent, IProcessorType[] types, IProcessorInstall install) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.block = block;
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = Status.OK_STATUS;
            ++i;
        }
        this.processorTypes = types;
        this.selectedProcessorType = install != null ? install.getProcessorType() : types[0];
        InstallStandin standin = null;
        if (install == null) {
            this.adding = true;
            standin = new InstallStandin(XSLTRuntime.createUniqueProcessorId((IProcessorType)this.selectedProcessorType), "", this.selectedProcessorType.getId(), null, new IProcessorJar[0]);
        } else {
            standin = new InstallStandin(install);
        }
        this.standinProcessor = standin;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createDialogFields(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(ProcessorMessages.AddProcessorDialog_processorName);
        this.processorNameField = new Text(parent, 2048);
        GridData gd = new GridData(0, 0, false, false);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        gd.horizontalSpan = 2;
        this.processorNameField.setLayoutData((Object)gd);
        label = new Label(parent, 0);
        label.setText(ProcessorMessages.AddProcessorDialog_processorType);
        this.processorTypeField = new ComboViewer(parent, 8);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.processorTypeField.getCombo().setLayoutData((Object)gd);
        this.processorTypeField.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object input;

            public Object[] getElements(Object inputElement) {
                return (IProcessorType[])this.input;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.input = newInput;
            }
        });
        this.processorTypeField.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IProcessorType)element).getLabel();
            }
        });
    }

    protected void createFieldListeners() {
        this.processorTypeField.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddProcessorDialog.this.updateProcessorType();
            }
        });
        this.processorNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddProcessorDialog.this.setProcessorNameStatus(AddProcessorDialog.this.validateProcessorName());
                AddProcessorDialog.this.updateStatusLine();
            }
        });
    }

    protected String getProcessorName() {
        return this.processorNameField.getText();
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.createDialogFields(parent);
        Label l = new Label(parent, 0);
        l.setText(ProcessorMessages.AddProcessorDialog_jars);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
        this.fLibraryBlock = new ProcessorLibraryBlock(this);
        Control block = this.fLibraryBlock.createControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        this.initializeFields();
        this.createFieldListeners();
        AddProcessorDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void updateProcessorType() {
        int selIndex = this.processorTypeField.getCombo().getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.processorTypes.length) {
            this.selectedProcessorType = this.processorTypes[selIndex];
        }
        this.fLibraryBlock.initializeFrom(this.standinProcessor, this.selectedProcessorType);
        this.updateStatusLine();
    }

    public void create() {
        super.create();
        this.processorNameField.setFocus();
    }

    private void initializeFields() {
        this.processorTypeField.setInput((Object)this.processorTypes);
        if (this.adding) {
            this.processorNameField.setText("");
            this.processorTypeField.setSelection((ISelection)new StructuredSelection((Object)this.processorTypes[0]));
            this.fLibraryBlock.initializeFrom(this.standinProcessor, this.selectedProcessorType);
        } else {
            this.processorTypeField.getCombo().setEnabled(false);
            this.processorTypeField.setSelection((ISelection)new StructuredSelection((Object)this.standinProcessor.getProcessorType()));
            this.processorNameField.setText(this.standinProcessor.getName());
            this.fLibraryBlock.initializeFrom(this.standinProcessor, this.selectedProcessorType);
        }
        this.setProcessorNameStatus(this.validateProcessorName());
        this.updateStatusLine();
    }

    private IStatus validateProcessorName() {
        IStatus status = Status.OK_STATUS;
        String name = this.processorNameField.getText();
        if (name == null || name.trim().length() == 0) {
            status = new Status(1, "org.eclipse.wst.xsl.debug.ui", 0, ProcessorMessages.AddProcessorDialog_enterName, null);
        } else if (this.block.isDuplicateName(name) && (this.standinProcessor == null || !name.equals(this.standinProcessor.getName()))) {
            status = new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, ProcessorMessages.AddProcessorDialog_duplicateName, null);
        }
        return status;
    }

    protected IStatus validateVersionStatus() {
        IStatus status = Status.OK_STATUS;
        return status;
    }

    protected void updateStatusLine() {
        IStatus max = null;
        IStatus[] iStatusArray = this.fStati;
        int n = this.fStati.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus curr = iStatusArray[n2];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++n2;
        }
        this.updateStatus(max);
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.adding) {
            this.setFieldValuesToProcessor(this.standinProcessor);
            this.block.processorAdded((IProcessorInstall)this.standinProcessor);
        }
    }

    protected void setFieldValuesToProcessor(InstallStandin processor) {
        IDebugger[] debuggers;
        processor.setName(this.processorNameField.getText());
        processor.setProcessorTypeId(this.selectedProcessorType.getId());
        IDebugger[] iDebuggerArray = debuggers = XSLTRuntime.getDebuggers();
        int n = debuggers.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugger element = iDebuggerArray[n2];
            if (element.getProcessorType().equals(this.selectedProcessorType)) {
                processor.setDebuggerId(element.getId());
            }
            ++n2;
        }
        this.fLibraryBlock.performApply(processor);
    }

    protected File getAbsoluteFileOrEmpty(String path) {
        if (path == null || path.length() == 0) {
            return new File("");
        }
        return new File(path).getAbsoluteFile();
    }

    private void setProcessorNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    protected void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected void setVersionStatus(IStatus status) {
        this.fStati[2] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_PROCESSOR_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }
}

