/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.FeaturesBlock;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.Messages;
import org.eclipse.wst.xsl.launching.IFeature;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;

public class FeaturesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final Map<IProcessorType, Map<String, String>> typeFeatureMap = new HashMap<IProcessorType, Map<String, String>>();
    private ComboViewer cViewer;
    private FeaturesBlock featuresBlock;

    public FeaturesPreferencePage() {
        this.setTitle(Messages.getString("FeaturesPreferencePage.0"));
        this.setDescription(Messages.getString("FeaturesPreferencePage.1"));
    }

    protected Control createContents(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        GridData gd = new GridData(0, 0x1000000, false, false);
        label.setText(Messages.getString("FeaturesPreferencePage.2"));
        label.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 12);
        gd = new GridData(0, 0x1000000, false, false);
        combo.setLayoutData((Object)gd);
        this.cViewer = new ComboViewer(combo);
        this.cViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private IProcessorType[] types;

            public Object[] getElements(Object inputElement) {
                return this.types;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.types = (IProcessorType[])newInput;
            }
        });
        this.cViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IProcessorType type = (IProcessorType)element;
                return type.getLabel();
            }
        });
        this.cViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IProcessorType type1 = (IProcessorType)e1;
                IProcessorType type2 = (IProcessorType)e2;
                return type1.getLabel().compareTo(type2.getLabel());
            }
        });
        this.cViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IProcessorType type = (IProcessorType)selection.getFirstElement();
                if (type != null) {
                    FeaturesPreferencePage.this.featuresBlock.setFeatureValues((Map)FeaturesPreferencePage.this.typeFeatureMap.get(type));
                    FeaturesPreferencePage.this.featuresBlock.setInput(type.getFeatures());
                } else {
                    FeaturesPreferencePage.this.featuresBlock.setFeatureValues(new HashMap<String, String>());
                    FeaturesPreferencePage.this.featuresBlock.setInput(new IFeature[0]);
                }
            }
        });
        this.cViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IProcessorType type = (IProcessorType)element;
                return !type.equals(XSLTRuntime.getProcessorType((String)"org.eclipse.wst.xsl.launching.processorType.jreDefault"));
            }
        });
        this.featuresBlock = new FeaturesBlock((DialogPage)this);
        this.featuresBlock.createControl(parent);
        this.setInput();
        return parent;
    }

    private void setInput() {
        IProcessorType[] types;
        IProcessorType[] iProcessorTypeArray = types = XSLTRuntime.getProcessorTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            this.typeFeatureMap.put(type, type.getFeatureValues());
            ++n2;
        }
        this.cViewer.setInput((Object)XSLTRuntime.getProcessorTypes());
        this.cViewer.setSelection((ISelection)new StructuredSelection((Object)FeaturesPreferencePage.getInitialType()), true);
    }

    static IProcessorType getInitialType() {
        IProcessorInstall install = XSLTRuntime.getDefaultProcessor();
        if (install != XSLTRuntime.getJREDefaultProcessor()) {
            return install.getProcessorType();
        }
        return XSLTRuntime.getProcessorTypesExclJREDefault()[0];
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IProcessorType[] types;
        IProcessorType[] iProcessorTypeArray = types = XSLTRuntime.getProcessorTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            this.typeFeatureMap.put(type, new HashMap());
            ++n2;
        }
        this.cViewer.setInput((Object)XSLTRuntime.getProcessorTypes());
        this.cViewer.setSelection((ISelection)new StructuredSelection((Object)FeaturesPreferencePage.getInitialType()), true);
        super.performDefaults();
    }

    public boolean performOk() {
        this.featuresBlock.saveColumnSettings();
        final boolean[] ok = new boolean[1];
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        XSLTRuntime.saveFeaturePreferences((Map)FeaturesPreferencePage.this.typeFeatureMap, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        XSLDebugUIPlugin.log(e);
                    }
                    ok[0] = !monitor.isCanceled();
                }
            };
            XSLDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            XSLDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            XSLDebugUIPlugin.log(e);
        }
        return ok[0];
    }
}

