/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.ParameterViewer;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class ParametersContentProvider
implements IStructuredContentProvider {
    private LaunchTransform stylesheetEntry;
    private ParameterViewer parameterViewer;

    public Object[] getElements(Object inputElement) {
        if (this.stylesheetEntry == null) {
            return new Object[0];
        }
        return this.stylesheetEntry.getParameters().toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.stylesheetEntry = (LaunchTransform)newInput;
        this.parameterViewer = (ParameterViewer)viewer;
    }

    public void dispose() {
    }

    public LaunchAttribute[] getParameters() {
        return this.stylesheetEntry.getParameters().toArray(new LaunchAttribute[0]);
    }

    public void removeParameters(LaunchAttribute[] entries) {
        LaunchAttribute[] launchAttributeArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchAttribute parameter = launchAttributeArray[n2];
            this.stylesheetEntry.getParameters().remove(parameter);
            ++n2;
        }
        TableItem[] items = this.parameterViewer.getTable().getItems();
        List<LaunchAttribute> entryList = Arrays.asList(entries);
        Object sel = null;
        int i = items.length - 1;
        while (i >= 0) {
            TableItem item = items[i];
            if (!entryList.contains(item.getData())) {
                sel = item.getData();
                break;
            }
            --i;
        }
        this.parameterViewer.remove(entries);
        if (sel != null) {
            this.parameterViewer.setSelection((ISelection)new StructuredSelection(sel), true);
        }
    }

    public void addParameter(LaunchAttribute parameter) {
        this.stylesheetEntry.getParameters().add(parameter);
        this.parameterViewer.add(parameter);
        this.parameterViewer.setSelection((ISelection)new StructuredSelection((Object)parameter), true);
    }
}

