/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.resolver;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.ResourceSelectionBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.ProcessorMessages;

public class WorkingDirectoryBlock
extends ResourceSelectionBlock {
    private String defaultWorkingDir;
    private Text defaultText;
    private Button useSpecificButton;

    public WorkingDirectoryBlock() {
        super(2, false, true, true);
    }

    protected String getMessage(int type) {
        switch (type) {
            case 1: {
                return ProcessorMessages.WorkingDirectoryBlock_DIRECTORY_NOT_SPECIFIED;
            }
            case 2: {
                return ProcessorMessages.WorkingDirectoryBlock_DIRECTORY_DOES_NOT_EXIST;
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return ProcessorMessages.WorkingDirectoryBlock_DEFAULT_RADIO;
            }
            case 5: {
                return ProcessorMessages.WorkingDirectoryBlock_OTHER_RADIO;
            }
            case 6: {
                return ProcessorMessages.WorkingDirectoryBlock_DIALOG_MESSAGE;
            }
            case 7: {
                return ProcessorMessages.WorkingDirectoryBlock_WORKSPACE_DIALOG_MESSAGE;
            }
            case 8: {
                return ProcessorMessages.WorkingDirectoryBlock_VARIABLES_BUTTON;
            }
            case 9: {
                return ProcessorMessages.WorkingDirectoryBlock_FILE_SYSTEM_BUTTON;
            }
            case 10: {
                return ProcessorMessages.WorkingDirectoryBlock_WORKSPACE_BUTTON;
            }
            case 11: {
                return ProcessorMessages.WorkingDirectoryBlock_WORKSPACE_DIALOG_TITLE;
            }
        }
        return "" + type;
    }

    protected void createCheckboxAndText(Composite parent) {
        Composite specificFileComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        specificFileComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        specificFileComp.setLayoutData((Object)gd);
        this.useDefaultCheckButton = this.createRadioButton(specificFileComp, ProcessorMessages.WorkingDirectoryBlock_1);
        this.useDefaultCheckButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.defaultText = new Text(specificFileComp, 2052);
        gd = new GridData(768);
        this.defaultText.setLayoutData((Object)gd);
        this.defaultText.setFont(parent.getFont());
        this.defaultText.setEnabled(false);
        this.useSpecificButton = this.createRadioButton(specificFileComp, ProcessorMessages.WorkingDirectoryBlock_2);
        this.resourceText = new Text(specificFileComp, 2052);
        gd = new GridData(768);
        this.resourceText.setLayoutData((Object)gd);
        this.resourceText.setFont(parent.getFont());
        this.resourceText.addModifyListener((ModifyListener)this.widgetListener);
    }

    protected void setDefaultResource() {
    }

    public String getName() {
        return ProcessorMessages.WorkingDirectoryBlock_3;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.setLaunchConfiguration(configuration);
            this.updateDefaultWorkingDir();
            this.outputFile = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR_WORKING_DIR", null);
            boolean useDefault = this.outputFile == null;
            this.useDefaultCheckButton.setSelection(useDefault);
            this.useSpecificButton.setSelection(!useDefault);
            this.resourceText.setEnabled(!useDefault);
            if (useDefault) {
                this.outputFile = "";
            }
            this.updateResourceText(useDefault);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    protected void updateResourceText(boolean useDefault) {
        super.updateResourceText(useDefault);
        this.defaultText.setText(this.defaultWorkingDir);
    }

    public void updateDefaultWorkingDir() {
        try {
            Path path;
            String pathExpr;
            ILaunchConfiguration config = this.getLaunchConfiguration();
            if (config != null && (pathExpr = config.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null)) != null && (path = this.getPath(pathExpr)) != null) {
                path = path.removeLastSegments(1);
                this.defaultWorkingDir = path.toPortableString();
                return;
            }
        }
        catch (CoreException coreException) {}
        this.defaultWorkingDir = System.getProperty("user.dir");
    }

    private Path getPath(String inputFile) {
        Path path = null;
        if (inputFile.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(inputFile);
                path = new Path(manager.performStringSubstitution(inputFile));
            }
            catch (CoreException coreException) {}
        } else if (inputFile.length() > 0) {
            path = new Path(inputFile);
        }
        return path;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean useDefault = this.useDefaultCheckButton.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR_WORKING_DIR", useDefault);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_PROCESSOR_WORKING_DIR", useDefault ? null : this.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_PROCESSOR_WORKING_DIR", true);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.required = this.useSpecificButton.getSelection();
        return super.isValid(config);
    }
}

