/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.invoker.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.eclipse.wst.xsl.invoker.ConfigurationException;
import org.eclipse.wst.xsl.invoker.IProcessorInvoker;
import org.eclipse.wst.xsl.invoker.config.CreationException;
import org.eclipse.wst.xsl.invoker.config.Messages;
import org.eclipse.wst.xsl.invoker.config.TransformDefinition;
import org.eclipse.wst.xsl.invoker.config.TypedValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PipelineDefinition {
    private String sourceURL;
    private String targetFile;
    private final List transformDefs = new ArrayList();
    private final Set features = new HashSet();
    private boolean useEmbedded;

    public PipelineDefinition() {
    }

    public PipelineDefinition(File launchFile) throws SAXException, IOException, ParserConfigurationException {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new BufferedInputStream(new FileInputStream(launchFile))));
    }

    public PipelineDefinition(Document doc) {
        Element rootEl = doc.getDocumentElement();
        Element featuresEl = (Element)rootEl.getElementsByTagName("Features").item(0);
        NodeList featureEls = featuresEl.getElementsByTagName("Feature");
        int i = 0;
        while (i < featureEls.getLength()) {
            Element featureEl = (Element)featureEls.item(i);
            String name = featureEl.getAttribute("name");
            String type = featureEl.getAttribute("type");
            String value = featureEl.getAttribute("value");
            this.addFeature(new TypedValue(name, type, value));
            ++i;
        }
        Element transformsEl = (Element)rootEl.getElementsByTagName("Transforms").item(0);
        String useEmbedded = transformsEl.getAttribute("useEmbedded");
        boolean embedded = Boolean.getBoolean(useEmbedded);
        this.setUseEmbedded(embedded);
        if (!embedded) {
            NodeList transformEls = transformsEl.getElementsByTagName("Transform");
            int i2 = 0;
            while (i2 < transformEls.getLength()) {
                Element transformEl = (Element)transformEls.item(i2);
                TransformDefinition tdef = TransformDefinition.fromXML(transformEl);
                this.addTransformDef(tdef);
                ++i2;
            }
        }
    }

    public void configure(IProcessorInvoker invoker) throws ConfigurationException {
        HashMap<String, Object> featureVals = new HashMap<String, Object>();
        Iterator iter = this.features.iterator();
        while (iter.hasNext()) {
            Object value;
            TypedValue feature = (TypedValue)iter.next();
            try {
                value = feature.createValue();
            }
            catch (CreationException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            featureVals.put(feature.uri, value);
        }
        invoker.setFeatures(featureVals);
        iter = this.transformDefs.iterator();
        while (iter.hasNext()) {
            TransformDefinition tdef = (TransformDefinition)iter.next();
            Map params = null;
            try {
                params = tdef.getParametersAsMap();
            }
            catch (CreationException e) {
                throw new ConfigurationException(Messages.getString("PipelineDefinition.8"), e);
            }
            URL url = null;
            try {
                url = new URL(tdef.getStylesheetURL());
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(String.valueOf(Messages.getString("PipelineDefinition.9")) + tdef.getStylesheetURL(), e);
            }
            Properties properties = tdef.getOutputProperties();
            try {
                invoker.addStylesheet(url, params, properties, null);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new ConfigurationException(String.valueOf(Messages.getString("PipelineDefinition.10")) + tdef.getStylesheetURL(), null);
            }
        }
    }

    public Set getFeatures() {
        return this.features;
    }

    public void addFeature(TypedValue feature) {
        this.features.add(feature);
    }

    public void removeFeature(TypedValue feature) {
        this.features.remove(feature);
    }

    public List getTransformDefs() {
        return this.transformDefs;
    }

    public void addTransformDef(TransformDefinition tdef) {
        this.transformDefs.add(tdef);
    }

    public void removeTransformDef(TransformDefinition tdef) {
        this.transformDefs.remove(tdef);
    }

    public void setUseEmbedded(boolean embedded) {
        this.useEmbedded = embedded;
    }

    public boolean useEmbedded() {
        return this.useEmbedded;
    }

    public Document toXML() throws ParserConfigurationException {
        Document doc = PipelineDefinition.newDocument();
        Element rootEl = doc.createElement("Pipeline");
        rootEl.setAttribute("source", this.sourceURL);
        rootEl.setAttribute("target", this.targetFile);
        doc.appendChild(rootEl);
        Element featuresEl = doc.createElement("Features");
        rootEl.appendChild(featuresEl);
        Iterator iter = this.features.iterator();
        while (iter.hasNext()) {
            TypedValue feature = (TypedValue)iter.next();
            Element featureEl = doc.createElement("Feature");
            featureEl.setAttribute("name", feature.uri);
            featureEl.setAttribute("type", feature.type);
            featureEl.setAttribute("value", feature.value);
            featuresEl.appendChild(featureEl);
        }
        rootEl.setAttribute("useEmbedded", String.valueOf(this.useEmbedded));
        if (!this.useEmbedded) {
            Element transformsEl = doc.createElement("Transforms");
            rootEl.appendChild(transformsEl);
            Iterator iter2 = this.transformDefs.iterator();
            while (iter2.hasNext()) {
                TransformDefinition tdef = (TransformDefinition)iter2.next();
                Element tdefEl = tdef.asXML(doc);
                transformsEl.appendChild(tdefEl);
            }
        }
        return doc;
    }

    private static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }
}

