/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.internal.core;

import org.eclipse.dltk.debug.core.model.ArrayScriptType;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.debug.core.model.HashScriptType;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.StringScriptType;

public class XQDTTypeFactory
implements IScriptTypeFactory {
    private static final String[] simpleTypes = new String[]{"string", "boolean", "decimal", "float", "double", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "hexBinary", "base64Binary", "anyURI", "QName", "NOTATION"};

    public IScriptType buildType(String type) {
        if ("string".equalsIgnoreCase(type)) {
            return new StringScriptType(type);
        }
        if (type.endsWith("*") || type.endsWith("+")) {
            return new ArrayScriptType();
        }
        if ("hash".equals(type)) {
            return new HashScriptType();
        }
        int i = 0;
        while (i < simpleTypes.length) {
            if (simpleTypes[i].equals(type)) {
                return new AtomicScriptType(type);
            }
            ++i;
        }
        return new ComplexScriptType(type);
    }
}

