/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.editor;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.wst.xquery.core.XQDTLanguageToolkit;
import org.eclipse.wst.xquery.internal.ui.folding.XQDTFoldingStructureProvider;
import org.eclipse.wst.xquery.internal.ui.text.XQDTXMLAutoInserter;
import org.eclipse.wst.xquery.internal.ui.text.rules.XQDTPartitioner;
import org.eclipse.wst.xquery.ui.XQDTUIPlugin;

public class XQDTEditor
extends ScriptEditor {
    public static final String EDITOR_CONTEXT = "#XQDTEditorContext";
    public static final String RULER_CONTEXT = "#XQDTRulerContext";
    private IFoldingStructureProvider fFoldingProvider = null;
    private ICharacterPairMatcher fPairMatcher = new DefaultCharacterPairMatcher("{}[]()".toCharArray(), "__xqdt_partitioning");
    private VerifyKeyListener fXmlAutoCloseTag = new XQDTXMLAutoInserter(this);
    private XQDTPartitioner fPartitioner;

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    public String getEditorId() {
        return "org.eclipse.wst.xquery.ui.editor.XQDTEditor";
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return XQDTLanguageToolkit.getDefault();
    }

    protected IPreferenceStore getScriptPreferenceStore() {
        return XQDTUIPlugin.getDefault().getPreferenceStore();
    }

    public ScriptTextTools getTextTools() {
        return XQDTUIPlugin.getDefault().getTextTools();
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 extension;
        if (document instanceof IDocumentExtension3 && (extension = (IDocumentExtension3)document).getDocumentPartitioner("__xqdt_partitioning") == null) {
            XQDTUIPlugin.getDefault().getTextTools().setupDocumentPartitioner(document, "__xqdt_partitioning");
            XQDTPartitioner partitioner = (XQDTPartitioner)extension.getDocumentPartitioner("__xqdt_partitioning");
            partitioner.setEditor(this, this.getPreferenceStore());
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fPartitioner);
            this.fPartitioner = partitioner;
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fPartitioner);
        }
    }

    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), this.getPreferenceStore());
    }

    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.fFoldingProvider == null) {
            this.fFoldingProvider = new XQDTFoldingStructureProvider();
        }
        return this.fFoldingProvider;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher(this.fPairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("editor.matching_brackets", "editor.matching_brackets_color");
        super.configureSourceViewerDecorationSupport(support);
    }

    public void dispose() {
        ISourceViewer sourceViewer;
        IDocumentExtension3 extension;
        IDocumentPartitioner partitioner;
        IDocument document;
        if (this.fFoldingProvider != null) {
            this.fFoldingProvider.uninstall();
        }
        if ((document = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) instanceof IDocumentExtension3 && (partitioner = (extension = (IDocumentExtension3)document).getDocumentPartitioner("__xqdt_partitioning")) != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)((XQDTPartitioner)partitioner));
        }
        if ((sourceViewer = this.getSourceViewer()) instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener(this.fXmlAutoCloseTag);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener(this.fXmlAutoCloseTag);
        }
    }
}

