/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text;

import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.SingleTokenScriptScanner;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xquery.internal.ui.text.IXQDTPartitions;
import org.eclipse.wst.xquery.internal.ui.text.XQDTCodeScanner;
import org.eclipse.wst.xquery.internal.ui.text.XQDTCompletionProcessor;
import org.eclipse.wst.xquery.internal.ui.text.XQDTContentAssistPreference;
import org.eclipse.wst.xquery.internal.ui.text.XQDTPreferenceInterpreter;
import org.eclipse.wst.xquery.internal.ui.text.XQDTStringCompletionProcessor;

public class XQDTSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private AbstractScriptScanner fCodeScanner;
    private AbstractScriptScanner fXmlCommentScanner;
    private AbstractScriptScanner fXmlCdataScanner;
    private AbstractScriptScanner fCommentScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fXmlAttributeValueScanner;
    private AbstractScriptScanner fXmlElementContentScanner;

    public XQDTSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (this.fPreferenceStore == null) {
            return super.getIndentPrefixes(sourceViewer, contentType);
        }
        XQDTPreferenceInterpreter prefs = new XQDTPreferenceInterpreter(this.fPreferenceStore);
        int tabWidth = prefs.getTabSize();
        int indentWidth = prefs.getIndentSize();
        if (indentWidth < tabWidth) {
            return new String[]{AutoEditUtils.getNSpaces((int)indentWidth), ""};
        }
        if (prefs.getTabStyle() == TabStyle.TAB) {
            return this.getIndentPrefixesForTab(tabWidth);
        }
        return this.getIndentPrefixesForSpaces(tabWidth);
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return XQDTContentAssistPreference.getDefault();
    }

    public IInformationPresenter getOutlinePresenter(ScriptSourceViewer viewer, boolean doCodeResolve) {
        return null;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IXQDTPartitions.XQDT_PARTITION_TYPES;
    }

    protected void initializeScanners() {
        this.fCodeScanner = new XQDTCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_multi_line_comment");
        this.fXmlCommentScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "XQDT_xml_comment");
        this.fXmlCdataScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "XQDT_xml_cdata");
        this.fStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fXmlAttributeValueScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "XQDT_xml_attr_value");
        this.fXmlElementContentScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "XQDT_xml_elem_content");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__xqdt_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xqdt_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fXmlCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__xqdt_xml_coment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xqdt_xml_coment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fXmlCdataScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__xqdt_xml_cdata");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xqdt_xml_cdata");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__xqdt_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xqdt_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fXmlAttributeValueScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__xqdt_xml_attribute_value");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xqdt_xml_attribute_value");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fXmlElementContentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__xqdt_xml_element_content");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xqdt_xml_element_content");
        return reconciler;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fXmlCommentScanner.affectsBehavior(event)) {
            this.fXmlCommentScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fXmlCommentScanner.affectsBehavior(event);
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        XQDTCompletionProcessor xqueryProcessor = new XQDTCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)xqueryProcessor, "__dftl_partition_content_type");
        XQDTStringCompletionProcessor stringProcessor = new XQDTStringCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__xqdt_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__xqdt_string");
    }
}

