/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.rules.CombinedWordRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.wst.xquery.core.codeassist.XQDTKeywords;
import org.eclipse.wst.xquery.core.text.XQDTWhitespaceDetector;
import org.eclipse.wst.xquery.core.text.XQDTWordDetector;

public class ExpressionRule
implements IRule {
    public static final String WORD_ANY_QNAME = "${qn}";
    public static final String WORD_FUNCTION_QNAME = "${fqn}";
    public static final String WORD_ITEM_TYPE = "${it}";
    public static final String WORD_WHITESPACE = "${ws}";
    private List<ExpressionSegment> fSegments = new ArrayList<ExpressionSegment>();
    private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(30);
    private XQDTWhitespaceDetector fWhitespaceDetector = new XQDTWhitespaceDetector();
    private XQDTWordDetector fWordDetector = new XQDTWordDetector();
    private boolean fTolleratesWhitespaces = true;
    private boolean fExpressionChecked = false;
    private int fCurrentSegment = 0;
    private int fTotalRewindLength = 0;
    private int fSecondSegmentStart = 0;

    public void addRuleSegment(String word, IToken token) {
        this.fSegments.add(new ExpressionSegment(word, token));
    }

    public void addRuleSegment(String word, IToken token, boolean endRule) {
        this.fSegments.add(new ExpressionSegment(word, token, endRule));
    }

    public void addRuleSegment(String word, int cardinality, IToken token) {
        Assert.isLegal((cardinality > 0 ? 1 : 0) != 0);
        this.fSegments.add(new ExpressionSegment(word, cardinality, token));
    }

    public void addRuleSegment(String word, int cardinality, IToken token, boolean endsRule) {
        Assert.isLegal((cardinality > 0 ? 1 : 0) != 0);
        this.fSegments.add(new ExpressionSegment(word, cardinality, token, endsRule));
    }

    public boolean getTolleratesWhitespaces() {
        return this.fTolleratesWhitespaces;
    }

    public void setTolleratesWhitespaces(boolean tolleratesWhitespaces) {
        this.fTolleratesWhitespaces = tolleratesWhitespaces;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int segment;
        IToken token;
        if (!this.fExpressionChecked) {
            this.fExpressionChecked = this.checkCompleteExpression(scanner);
            this.rewindScanner(scanner);
            if (this.fExpressionChecked) {
                return this.fSegments.get(0).getToken();
            }
            return Token.UNDEFINED;
        }
        if (this.fTolleratesWhitespaces && this.fCurrentSegment < this.fSegments.size() - 1 && (token = this.consumeWhitespaces(scanner)) != null) {
            return token;
        }
        if ((segment = ++this.fCurrentSegment) == this.fSegments.size() - 1 || this.fSegments.get(segment).endsRule()) {
            this.fCurrentSegment = 0;
            this.fExpressionChecked = false;
        }
        this.consumeSegment(scanner, segment);
        return this.fSegments.get(segment).getToken();
    }

    public boolean mustCompleteExpression() {
        return this.fExpressionChecked;
    }

    private boolean checkCompleteExpression(ICharacterScanner scanner) {
        int i = 0;
        while (i < this.fSegments.size()) {
            int c;
            ExpressionSegment segment = this.fSegments.get(i);
            if (segment.equals(WORD_WHITESPACE)) {
                c = scanner.read();
                if (this.fWhitespaceDetector.isWhitespace((char)c)) {
                    while (this.fWhitespaceDetector.isWhitespace((char)this.consume(scanner))) {
                    }
                }
                scanner.unread();
            } else if (segment.equals(WORD_ANY_QNAME) || segment.equals(WORD_FUNCTION_QNAME) || segment.equals(WORD_ITEM_TYPE)) {
                String name = this.scanName(scanner);
                int segmentLength = name.length();
                if (segmentLength == 0) {
                    return false;
                }
                int c2 = this.consume(scanner);
                if ((char)c2 == ':') {
                    ++segmentLength;
                    int localNameLength = this.scanName(scanner).length();
                    segmentLength += localNameLength;
                } else {
                    this.unconsume(scanner);
                    if (segment.equals(WORD_FUNCTION_QNAME) && Arrays.binarySearch(XQDTKeywords.XQUERY_KEYWORDS_RESERVED_FN_NAMES, name) >= 0 || segment.equals(WORD_ITEM_TYPE) && Arrays.binarySearch(XQDTKeywords.XQUERY_KEYWORDS_ITEM_TYPES, name) < 0) {
                        return false;
                    }
                }
                segment.setLength(segmentLength);
                if (i == 0) {
                    this.fSecondSegmentStart = segmentLength;
                }
                if (this.fTolleratesWhitespaces && i < this.fSegments.size() - 1) {
                    c2 = scanner.read();
                    if (this.fWhitespaceDetector.isWhitespace((char)c2)) {
                        while (this.fWhitespaceDetector.isWhitespace((char)this.consume(scanner))) {
                        }
                    }
                    scanner.unread();
                }
            } else {
                this.fBuffer.clear();
                c = scanner.read();
                while (c != -1 && this.fBuffer.length() < segment.length()) {
                    this.fBuffer.append((char)c);
                    c = this.consume(scanner);
                    if (i != 0) continue;
                    ++this.fSecondSegmentStart;
                }
                if (this.fTolleratesWhitespaces && this.fWhitespaceDetector.isWhitespace((char)c)) {
                    while (this.fWhitespaceDetector.isWhitespace((char)this.consume(scanner))) {
                    }
                }
                scanner.unread();
                if (segment.length() != this.fBuffer.length() || !segment.equals(this.fBuffer)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private String scanName(ICharacterScanner scanner) {
        this.fBuffer.clear();
        int c = scanner.read();
        if (this.fWordDetector.isWordStart((char)c)) {
            while (this.fWordDetector.isWordPart((char)c)) {
                this.fBuffer.append((char)c);
                c = this.consume(scanner);
            }
        }
        scanner.unread();
        return this.fBuffer.toString();
    }

    private void rewindScanner(ICharacterScanner scanner) {
        int length = this.fExpressionChecked ? this.fTotalRewindLength - this.fSecondSegmentStart : this.fTotalRewindLength;
        int i = 0;
        while (i < length) {
            scanner.unread();
            ++i;
        }
        this.fTotalRewindLength = 0;
        this.fSecondSegmentStart = 0;
    }

    private int consume(ICharacterScanner scanner) {
        ++this.fTotalRewindLength;
        return scanner.read();
    }

    private void unconsume(ICharacterScanner scanner) {
        --this.fTotalRewindLength;
        scanner.unread();
    }

    private void consumeSegment(ICharacterScanner scanner, int segment) {
        int i = 0;
        while (i < this.fSegments.get(segment).length()) {
            scanner.read();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private IToken consumeWhitespaces(ICharacterScanner scanner) {
        c = scanner.read();
        if (this.fWhitespaceDetector.isWhitespace((char)c)) ** GOTO lbl6
        scanner.unread();
        return null;
lbl-1000:
        // 1 sources

        {
            c = scanner.read();
lbl6:
            // 2 sources

            ** while (this.fWhitespaceDetector.isWhitespace((char)((char)c)))
        }
lbl7:
        // 1 sources

        scanner.unread();
        return Token.WHITESPACE;
    }

    public class ExpressionSegment
    extends CombinedWordRule.CharacterBuffer {
        private int fCardinality;
        private IToken fToken;
        private int fLength;
        private boolean fEndsRule;

        public ExpressionSegment(String word, int cardinality, IToken token) {
            this(word, cardinality, token, false);
        }

        public ExpressionSegment(String word, int cardinality, IToken token, boolean endsRule) {
            super(word);
            this.fLength = 0;
            this.fEndsRule = false;
            this.fCardinality = cardinality;
            this.fToken = token;
            this.fEndsRule = endsRule;
        }

        public ExpressionSegment(String word, IToken token) {
            this(word, 1, token, false);
        }

        public ExpressionSegment(String word, IToken token, boolean endsRule) {
            this(word, 1, token, endsRule);
        }

        public ExpressionSegment(String word, int cardinality) {
            this(word, cardinality, Token.UNDEFINED);
        }

        public ExpressionSegment(String word) {
            this(word, 1, Token.UNDEFINED, false);
        }

        public ExpressionSegment(String word, boolean endRule) {
            this(word, 1, Token.UNDEFINED, endRule);
        }

        public int getCardinality() {
            return this.fCardinality;
        }

        public IToken getToken() {
            return this.fToken;
        }

        public int length() {
            if (this.toString().matches("\\$\\{\\w+\\}")) {
                return this.fLength;
            }
            return super.length();
        }

        public void setLength(int length) {
            this.fLength = length;
        }

        public boolean endsRule() {
            return this.fEndsRule;
        }
    }
}

