/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.wst.xquery.internal.ui.text.rules.ISemanticRule;

public class SemanticMultiEndPatternRule
extends PatternRule
implements ISemanticRule {
    private Comparator<char[]> fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;
    protected String[] fEndSequences;
    protected boolean isMultiEnd = false;
    protected boolean fIsExclusive = false;

    public SemanticMultiEndPatternRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, false);
    }

    public SemanticMultiEndPatternRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF, false);
    }

    public SemanticMultiEndPatternRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF, escapeContinuesLine);
    }

    public SemanticMultiEndPatternRule(boolean isExclusive, String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOL);
        this.fIsExclusive = isExclusive;
    }

    public SemanticMultiEndPatternRule(boolean isExclusive, String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(isExclusive, startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF, false);
    }

    public SemanticMultiEndPatternRule(boolean isExclusive, String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF, escapeContinuesLine);
        this.fIsExclusive = isExclusive;
    }

    public SemanticMultiEndPatternRule(String startSequence, String[] endSequences, IToken token, char escapeCharacter, boolean breaksOnEOL) {
        this(startSequence, "", token, escapeCharacter, breaksOnEOL, false);
    }

    public SemanticMultiEndPatternRule(String startSequence, String[] endSequences, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(startSequence, "", token, escapeCharacter, breaksOnEOL, breaksOnEOF, false);
    }

    public SemanticMultiEndPatternRule(String startSequence, String[] endSequences, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        super(startSequence, "", token, escapeCharacter, breaksOnEOL, breaksOnEOF, escapeContinuesLine);
        this.fEndSequences = endSequences;
        this.isMultiEnd = true;
    }

    public SemanticMultiEndPatternRule(boolean isExclusive, String startSequence, String[] endSequences, IToken token, char escapeCharacter, boolean breaksOnEOL) {
        this(isExclusive, startSequence, endSequences, token, escapeCharacter, breaksOnEOL, false);
    }

    public SemanticMultiEndPatternRule(boolean isExclusive, String startSequence, String[] endSequences, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(isExclusive, startSequence, endSequences, token, escapeCharacter, breaksOnEOL, breaksOnEOF, false);
    }

    public SemanticMultiEndPatternRule(boolean isExclusive, String startSequence, String[] endSequences, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        super(startSequence, "", token, escapeCharacter, breaksOnEOL, breaksOnEOF, escapeContinuesLine);
        this.fEndSequences = endSequences;
        this.isMultiEnd = true;
        this.fIsExclusive = isExclusive;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        block11: {
            if (!this.fIsExclusive && !this.isMultiEnd) {
                return super.endSequenceDetected(scanner);
            }
            originalDelimiters = scanner.getLegalLineDelimiters();
            count = originalDelimiters.length;
            if (this.fLineDelimiters != null && originalDelimiters.length == count) ** GOTO lbl9
            this.fSortedLineDelimiters = new char[count][];
            break block11;
lbl-1000:
            // 1 sources

            {
                --count;
lbl9:
                // 2 sources

                ** while (count > 0 && this.fLineDelimiters[count - 1] == originalDelimiters[count - 1])
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        block1: while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                if (this.fEndSequence.length == 1 && this.fEndSequence[0] == c) {
                    if (scanner.read() == c) continue;
                    scanner.unread();
                    return true;
                }
                if (this.fEscapeContinuesLine) {
                    c = scanner.read();
                    i = 0;
                    while (i < this.fSortedLineDelimiters.length) {
                        if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) continue block1;
                        ++i;
                    }
                    continue;
                }
                c = scanner.read();
                continue;
            }
            if (this.firstCharacterMatch(c)) {
                if (!this.oneEndSequenceDetected(scanner, c)) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            i = 0;
            while (i < this.fSortedLineDelimiters.length) {
                if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) {
                    return true;
                }
                ++i;
            }
        }
        return this.fBreaksOnEOF != false;
    }

    protected boolean oneEndSequenceDetected(ICharacterScanner scanner, int startChar) {
        int i = 0;
        while (i < this.fEndSequences.length) {
            if (this.fEndSequences[i].length() > 0 && this.fEndSequences[i].charAt(0) == (char)startChar && this.sequenceDetected(scanner, this.fEndSequences[i].toCharArray(), true)) {
                if (this.fIsExclusive) {
                    int j = 0;
                    while (j < this.fEndSequences[i].length()) {
                        scanner.unread();
                        ++j;
                    }
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean directEndSequenceDetected(ICharacterScanner scanner) {
        if (this.fIsExclusive) {
            int c = scanner.read();
            int i = 0;
            while (i < this.fEndSequences.length) {
                if (this.fEndSequences[i].length() > 0 && this.fEndSequences[i].charAt(0) == (char)c && this.sequenceDetected(scanner, this.fEndSequences[i].toCharArray(), true)) {
                    int j = 0;
                    while (j < this.fEndSequences[i].length()) {
                        scanner.unread();
                        ++j;
                    }
                    return true;
                }
                ++i;
            }
            scanner.unread();
        }
        return false;
    }

    private boolean firstCharacterMatch(int c) {
        String[] stringArray = this.fEndSequences;
        int n = this.fEndSequences.length;
        int n2 = 0;
        while (n2 < n) {
            String end = stringArray[n2];
            if (end.length() > 0 && end.charAt(0) == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getContentType() {
        return (String)this.fToken.getData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DecreasingCharArrayLengthComparator
    implements Comparator<char[]> {
        private DecreasingCharArrayLengthComparator() {
        }

        @Override
        public int compare(char[] o1, char[] o2) {
            return o2.length - o1.length;
        }
    }
}

