/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xquery.internal.launching.xqdoc.XQDocJob;
import org.eclipse.wst.xquery.internal.ui.XQDTImages;
import org.eclipse.wst.xquery.internal.ui.wizards.XQDocWizardPage;
import org.eclipse.wst.xquery.launching.xqdoc.AbstractXQDocRuntime;
import org.eclipse.wst.xquery.launching.xqdoc.XQDocUtil;
import org.eclipse.wst.xquery.ui.XQDTUIPlugin;

public class XQDocWizard
extends Wizard
implements IExportWizard {
    private AbstractXQDocRuntime fRuntime;
    private XQDocWizardPage fPage;

    public static void openXQDocWizard(Shell shell, AbstractXQDocRuntime runtime, IStructuredSelection selection) {
        XQDocWizard wizard = new XQDocWizard(runtime);
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }

    public XQDocWizard(AbstractXQDocRuntime runtime) {
        this.fRuntime = runtime;
    }

    public void addPages() {
        super.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        IPath outDir = this.fPage.getOutputDir().append("xqdoc");
        this.fRuntime.init(this.fPage.getQueries(), outDir, this.fPage.getStyleSheet());
        XQDocJob job = XQDocUtil.createXQDocJob((AbstractXQDocRuntime)this.fRuntime);
        job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(XQDTImages.WIZBAN_NEW_XQDOC);
        this.setWindowTitle("New XQDoc Documentation");
        this.setDialogSettings(XQDTUIPlugin.getDefault().getDialogSettings());
        this.fPage = new XQDocWizardPage(selection);
    }
}

