/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.misc.CheckboxTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.internal.ui.XQDTImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQDocWizardPage
extends NewElementWizardPage
implements IDialogFieldListener {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private static final Object[] NO_CHILDREN = new Object[0];
    private CheckboxTreeAndListGroup fSelectionGroup;
    private StringButtonDialogField fDestinationLocationField;
    private ComboDialogField fStylesheetCombo;
    private IStructuredSelection fSelection;
    private String[] fStylesheets = new String[]{"zorba.css", "28msec.css", "mark_logic.css"};
    private IScriptProject fProject;

    protected XQDocWizardPage(IStructuredSelection selection) {
        super("XQDoc Generation");
        this.setTitle("XQDoc Generation");
        this.setDescription("Selection the XQuery files to generate documentation from");
        this.setImageDescriptor(XQDTImages.WIZBAN_NEW_XQDOC);
        this.fSelection = selection;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        composite.setLayoutData((Object)gd);
        ArrayList<IScriptProject> projects = new ArrayList<IScriptProject>(1);
        IScriptProject project = this.getProject();
        if (project != null) {
            projects.add(project);
        }
        this.fSelectionGroup = new CheckboxTreeAndListGroup(composite, projects, this.getTreeResourceProvider(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getListResourceProvider(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
        this.setTreeSelection();
        composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        composite.setLayoutData((Object)gd);
        IStringButtonAdapter adapter = new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                XQDocWizardPage.this.browseForDestination();
            }
        };
        this.fDestinationLocationField = new StringButtonDialogField(adapter);
        this.fDestinationLocationField.setLabelText("Destination:");
        this.fDestinationLocationField.setButtonLabel("Browse...");
        this.fDestinationLocationField.doFillIntoGrid(composite, 3);
        this.fDestinationLocationField.getTextControl(null).setLayoutData((Object)new GridData(768));
        if (project != null) {
            this.fDestinationLocationField.setText(project.getResource().getLocation().toOSString());
        }
        new Label(composite, 0).setText("Stylesheet:");
        this.fStylesheetCombo = new ComboDialogField(8);
        this.fStylesheetCombo.setItems(this.fStylesheets);
        this.fStylesheetCombo.getComboControl(composite);
        this.fStylesheetCombo.selectItem(0);
        this.addControlListeners();
        this.setControl((Control)parent);
    }

    private void addControlListeners() {
        this.fDestinationLocationField.setDialogFieldListener((IDialogFieldListener)this);
        this.fSelectionGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                XQDocWizardPage.this.setPageComplete(XQDocWizardPage.this.isValid());
            }
        });
    }

    public IScriptProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fSelection == null || this.fSelection.size() == 0) {
            return null;
        }
        Object element = this.fSelection.getFirstElement();
        IProject project = null;
        if (element instanceof IContainer) {
            project = ((IContainer)element).getProject();
        } else if (element instanceof IModelElement) {
            project = ((IModelElement)element).getScriptProject().getProject();
        } else if (element instanceof IResource) {
            project = ((IResource)element).getProject();
        }
        if (project != null) {
            try {
                if (project.hasNature("org.eclipse.wst.xquery.core.nature")) {
                    this.fProject = DLTKCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {}
        }
        return this.fProject;
    }

    private void setTreeSelection() {
        if (this.fSelection == null || this.fSelection.size() == 0) {
            return;
        }
        Object selected = this.fSelection.getFirstElement();
        if (selected instanceof IResource) {
            selected = DLTKCore.create((IResource)((IResource)selected));
        }
        if (selected instanceof IScriptFolder) {
            this.fSelectionGroup.initialCheckTreeItem(selected);
        } else if (selected instanceof IScriptProject) {
            this.fSelectionGroup.initialCheckTreeItem(selected);
            this.fSelectionGroup.setAllSelections(true);
        } else if (selected instanceof ISourceModule) {
            ISourceModule module = (ISourceModule)selected;
            IModelElement parent = module.getParent();
            HashMap items = new HashMap(1);
            ArrayList<IResource> list = new ArrayList<IResource>(1);
            list.add(module.getResource());
            items.put(parent, list);
            this.fSelectionGroup.initialCheckTreeItem((Object)parent);
            this.fSelectionGroup.updateSelections(items);
        }
        this.fSelectionGroup.expandAll();
    }

    private void browseForDestination() {
        String newPath;
        IEnvironment environment = EnvironmentManager.getLocalEnvironment();
        IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
        if (environmentUI != null && (newPath = environmentUI.selectFolder(this.getShell(), this.fDestinationLocationField.getText().trim())) != null) {
            this.fDestinationLocationField.setText(newPath);
        }
    }

    private ITreeContentProvider getListResourceProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IScriptFolder) {
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    IScriptFolder folder = (IScriptFolder)o;
                    try {
                        ISourceModule[] modules;
                        ISourceModule[] iSourceModuleArray = modules = folder.getSourceModules();
                        int n = modules.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISourceModule module = iSourceModuleArray[n2];
                            ModuleDeclaration modDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                            if (modDecl instanceof XQueryLibraryModule) {
                                results.add(module.getResource());
                            }
                            ++n2;
                        }
                    }
                    catch (ModelException modelException) {
                        return NO_CHILDREN;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return NO_CHILDREN;
            }
        };
    }

    private ITreeContentProvider getTreeResourceProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IScriptProject) {
                    ArrayList<IScriptFolder> results = new ArrayList<IScriptFolder>();
                    IScriptProject project = (IScriptProject)o;
                    try {
                        IScriptFolder[] folders;
                        IScriptFolder[] iScriptFolderArray = folders = project.getScriptFolders();
                        int n = folders.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IScriptFolder folder = iScriptFolderArray[n2];
                            if (folder.containsScriptResources() && !folder.isReadOnly()) {
                                results.add(folder);
                            }
                            ++n2;
                        }
                    }
                    catch (ModelException modelException) {
                        return NO_CHILDREN;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return NO_CHILDREN;
            }
        };
    }

    public void dialogFieldChanged(DialogField field) {
        this.setPageComplete(this.isValid());
    }

    public String getStyleSheet() {
        return this.fStylesheetCombo.getItems()[this.fStylesheetCombo.getSelectionIndex()];
    }

    public Collection<IPath> getQueries() {
        ArrayList<IPath> queries = new ArrayList<IPath>();
        Iterator it = this.fSelectionGroup.getAllCheckedListItems();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IFile)) continue;
            queries.add(((IFile)o).getLocation());
        }
        return queries;
    }

    public IPath getOutputDir() {
        return new Path(this.fDestinationLocationField.getText().trim());
    }

    public boolean isPageComplete() {
        if (!this.isValid()) {
            return false;
        }
        return super.isPageComplete();
    }

    private boolean isValid() {
        String destDir = this.fDestinationLocationField.getText().trim();
        if (destDir.length() == 0) {
            this.setErrorMessage("The destination directory cannot be empty");
            return false;
        }
        if (!this.hasSelectedQuery()) {
            this.setErrorMessage("At least one XQuery file must be selected");
            return false;
        }
        File dir = new File(destDir);
        if (!dir.exists() || !dir.isDirectory()) {
            this.setErrorMessage("\"" + destDir + "\" is not a valid directory");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean hasSelectedQuery() {
        Iterator iter = this.fSelectionGroup.getAllCheckedListItems();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IFile)) continue;
            return true;
        }
        return false;
    }
}

