/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.ui;

import java.util.List;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.wst.xquery.core.model.ast.XQueryFunctionDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryParam;
import org.eclipse.wst.xquery.core.model.ast.XQueryVarDecl;

public class XQDTScriptElementLabels
extends ScriptElementLabels {
    protected void getMethodLabel(IMethod method, long flags, StringBuffer buf) {
        String name = method.getElementName();
        String key = null;
        try {
            key = String.valueOf(name) + method.getParameters().length;
        }
        catch (ModelException modelException) {
            key = name;
        }
        ISourceModule sModule = (ISourceModule)method.getParent();
        XQueryModule xqModule = (XQueryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)sModule);
        XQueryFunctionDecl functionDecl = xqModule.getFunction(key);
        buf.append(name);
        buf.append('(');
        if (functionDecl == null) {
            buf.append("...)");
            return;
        }
        List params = functionDecl.getArguments();
        int i = 0;
        while (i < params.size()) {
            XQueryParam param = (XQueryParam)params.get(i);
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("$" + param.getName());
            if (param.getType() != null) {
                buf.append(" as " + param.getType());
            }
            ++i;
        }
        buf.append(')');
        if (functionDecl.getReturnType() != null) {
            buf.append(" as " + functionDecl.getReturnType());
        }
    }

    protected void getFieldLabel(IField field, long flags, StringBuffer buf) {
        ISourceModule sModule = (ISourceModule)field.getParent();
        XQueryModule xqModule = (XQueryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)sModule);
        XQueryVarDecl varDecl = xqModule.getVariable(field.getElementName());
        buf.append("$" + varDecl.getName());
        if (varDecl.getType() != null) {
            buf.append(" as " + varDecl.getType());
        }
    }

    public void getDeclarationLabel(IModelElement declaration, long flags, StringBuffer buf) {
        ISourceModule sModule = (ISourceModule)declaration.getParent();
        XQueryLibraryModule xqModule = (XQueryLibraryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)sModule);
        buf.append(String.valueOf(xqModule.getNamespacePrefix()) + " = '" + xqModule.getNamespaceUri().getValue() + "'");
    }
}

