/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.ui.interpreters;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.launching.LazyFileHandle;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.xquery.debug.ui.interpreters.AbstractAddInterpreterDialogBlock;
import org.eclipse.wst.xquery.debug.ui.interpreters.AbstractInterpreterEnvironmentVariablesBlock;
import org.eclipse.wst.xquery.debug.ui.interpreters.IInterpreterNameProvider;

public class AddLocalInterpreterDialogBlock
extends AbstractAddInterpreterDialogBlock
implements IInterpreterNameProvider {
    protected StringDialogField fInterpreterNameField;
    protected StringButtonDialogField fInterpreterLocationField;
    protected StringDialogField fInterpreterArgsField;
    protected AbstractInterpreterEnvironmentVariablesBlock fEnvironmentVariablesBlock;
    private IStatus[] fStati = new IStatus[5];

    public AddLocalInterpreterDialogBlock() {
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
    }

    protected void addControlsTo(Composite parent) {
        int numColumns = 3;
        this.fInterpreterNameField = new StringDialogField();
        this.fInterpreterNameField.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.fInterpreterNameField.doFillIntoGrid(parent, numColumns);
        this.fInterpreterLocationField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddLocalInterpreterDialogBlock.this.browseForInstallation();
            }
        });
        this.fInterpreterLocationField.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterExecutableName);
        this.fInterpreterLocationField.setButtonLabel(InterpretersMessages.addInterpreterDialog_browse1);
        this.fInterpreterLocationField.doFillIntoGrid(parent, numColumns);
        ((GridData)this.fInterpreterLocationField.getTextControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        this.fInterpreterArgsField = new StringDialogField();
        this.fInterpreterArgsField.setLabelText(InterpretersMessages.AddInterpreterDialog_iArgs);
        this.fInterpreterArgsField.doFillIntoGrid(parent, numColumns - 1);
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("Variables...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(AddLocalInterpreterDialogBlock.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    AddLocalInterpreterDialogBlock.this.fInterpreterArgsField.getTextControl(null).insert(variable);
                }
            }
        });
        this.fEnvironmentVariablesBlock = this.createEnvironmentVariablesBlock();
        if (this.fEnvironmentVariablesBlock != null) {
            Label l = new Label(parent, 0);
            l.setText(InterpretersMessages.AddScriptInterpreterDialog_interpreterEnvironmentVariables);
            GridData gd = new GridData(768);
            gd.horizontalSpan = numColumns;
            l.setLayoutData((Object)gd);
            Control block = this.fEnvironmentVariablesBlock.createControl(parent);
            gd = new GridData(1808);
            gd.horizontalSpan = numColumns;
            block.setLayoutData((Object)gd);
        }
    }

    protected AbstractInterpreterEnvironmentVariablesBlock createEnvironmentVariablesBlock() {
        return null;
    }

    public void setFieldValuesToInterpreter(IInterpreterInstall install) {
        IEnvironment selectedEnv = this.fAddInterpreterDialog.getEnvironment();
        install.setInstallLocation((IFileHandle)new LazyFileHandle(selectedEnv.getId(), (IPath)new Path(this.getInterpreterLocation())));
        install.setName(this.getInterpreterName());
        install.setInterpreterArgs(this.getInterpreterArguments());
        if (this.fEnvironmentVariablesBlock != null) {
            this.fEnvironmentVariablesBlock.performApply(install);
        }
    }

    protected IStatus validateInterpreterLocation() {
        String pName;
        String name;
        IFileHandle file;
        IEnvironment selectedEnv = this.fAddInterpreterDialog.getEnvironment();
        String locationName = this.getInterpreterLocation();
        StatusInfo s = null;
        if (locationName.length() == 0) {
            file = null;
            s = new StatusInfo(1, InterpretersMessages.addInterpreterDialog_enterLocation);
        } else {
            file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)selectedEnv, (IPath)new Path(locationName));
            if (!file.exists()) {
                s = new StatusInfo(4, InterpretersMessages.addInterpreterDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        temp[0] = AddLocalInterpreterDialogBlock.this.fAddInterpreterDialog.getInterpreterType().validateInstallLocation(file);
                    }
                });
                s = temp[0];
            }
        }
        if (s.isOK() && ((name = this.getInterpreterName()) == null || name.length() == 0) && file != null && (pName = this.generateInterpreterName(file.toOSString())) != null) {
            this.fInterpreterNameField.setText(pName);
        }
        return s;
    }

    protected String getInterpreterLocation() {
        return this.fInterpreterLocationField.getText().trim();
    }

    protected String getInterpreterName() {
        return this.fInterpreterNameField.getText().trim();
    }

    protected String getInterpreterArguments() {
        return this.fInterpreterArgsField.getText().trim();
    }

    protected void browseForInstallation() {
        String newPath;
        IEnvironment environment = this.getEnvironemnt();
        IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
        if (environmentUI != null && (newPath = environmentUI.selectFile(this.getShell(), 1)) != null) {
            this.fInterpreterLocationField.setText(newPath);
        }
    }

    public void initializeFields(IInterpreterInstall install) {
        if (install == null) {
            this.fInterpreterNameField.setText("");
            this.fInterpreterLocationField.setText("");
            this.fInterpreterArgsField.setText("");
        } else {
            this.fInterpreterNameField.setText(install.getName());
            this.fInterpreterLocationField.setText(install.getRawInstallLocation().toOSString());
            String interpreterArgs = install.getInterpreterArgs();
            if (interpreterArgs != null) {
                this.fInterpreterArgsField.setText(interpreterArgs);
            }
            if (this.fEnvironmentVariablesBlock != null) {
                this.fEnvironmentVariablesBlock.initializeFrom(install, install.getInterpreterInstallType());
            }
        }
        this.setInterpreterNameStatus(this.validateInterpreterName());
        this.setInterpreterLocationStatus(this.validateInterpreterLocation());
        this.updateStatus();
    }

    public void createFieldListeners() {
        this.fInterpreterNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddLocalInterpreterDialogBlock.this.setInterpreterNameStatus(AddLocalInterpreterDialogBlock.this.validateInterpreterName());
                AddLocalInterpreterDialogBlock.this.updateStatus();
            }
        });
        this.fInterpreterLocationField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddLocalInterpreterDialogBlock.this.setInterpreterLocationStatus(AddLocalInterpreterDialogBlock.this.validateInterpreterLocation());
                AddLocalInterpreterDialogBlock.this.updateStatus();
            }
        });
    }

    public void updateStatus() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.getStatusListener().statusChanged(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.getStatusListener().statusChanged(max);
    }

    private void setInterpreterNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    private void setInterpreterLocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    protected IStatus validateInterpreterName() {
        StatusInfo status = new StatusInfo();
        String name = this.getInterpreterName();
        if (name == null || name.length() == 0) {
            status.setInfo(InterpretersMessages.addInterpreterDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedInterpreter == null || !name.equals(this.fEditedInterpreter.getName()))) {
            status.setError(InterpretersMessages.addInterpreterDialog_duplicateName);
        }
        return status;
    }

    public void setFocus() {
        this.fInterpreterNameField.setFocus();
    }

    public String generateInterpreterName(String location) {
        return null;
    }

    protected boolean validateGeneratedName(String name) {
        IInterpreterInstallType[] types = this.fAddInterpreterDialog.getInterpreterTypes();
        int i = 0;
        while (i < types.length) {
            IInterpreterInstallType type = types[i];
            IInterpreterInstall inst = type.findInterpreterInstallByName(name);
            if (inst != null) {
                return inst == this.fEditedInterpreter;
            }
            ++i;
        }
        return true;
    }
}

