/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.dbgp;

import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;
import org.eclipse.wst.xquery.debug.dbgp.ErrorMessages;

public class DbgpRequestParser {
    public static DbgpRequest parse(String cmdStr) throws DbgpProtocolException {
        DbgpRequest request = null;
        if (!cmdStr.matches("(\\w+)\\s(.+)")) {
            throw new DbgpProtocolException(ErrorMessages.DbgpError.COMMAND_PARSE_ERROR.toString());
        }
        String[] parts = cmdStr.split("\\s", 2);
        request = new DbgpRequest(parts[0]);
        String[] args = parts[1].split("\\s");
        int argc = args.length;
        if (args[args.length - 2].equals("--")) {
            request.setData(Base64Helper.decodeString((String)args[args.length - 1]));
            argc -= 2;
        }
        int i = 0;
        while (i < argc) {
            request.addOption(args[i], (Object)args[i + 1]);
            i += 2;
        }
        return request;
    }
}

