/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.dbgp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlElement {
    private static final String PACKET_WITH_DATA_TEMPLATE = "<%1$s%2$s>%3$s</%1$s>";
    private static final String PACKET_WITHOUT_DATA_TEMPLATE = "<%1$s%2$s/>";
    private String fName;
    private Map<String, String> fAttributes = new HashMap<String, String>();
    private String fData;
    private boolean fEncodeData = true;

    public XmlElement(String name) {
        this.fName = name;
    }

    public void addAttribute(String name, String value) {
        this.fAttributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.fAttributes.get(name);
    }

    public void removeAttribute(String name) {
        this.fAttributes.remove(name);
    }

    public String getData() {
        return this.fData;
    }

    public void setData(String data) {
        this.setData(data, false);
    }

    public void setData(String data, boolean encode) {
        this.fData = data;
        this.fEncodeData = encode;
    }

    public String toXml() {
        if (this.fData != null) {
            return String.format(PACKET_WITH_DATA_TEMPLATE, this.fName, this.attributesToXml(this.fAttributes), this.prepareData(this.fData));
        }
        return String.format(PACKET_WITHOUT_DATA_TEMPLATE, this.fName, this.attributesToXml(this.fAttributes));
    }

    public String toString() {
        return this.toXml();
    }

    private String attributesToXml(Map<String, String> attributes) {
        StringBuffer sb = new StringBuffer();
        for (String name : attributes.keySet()) {
            sb.append(" " + name + "='" + attributes.get(name) + "'");
        }
        return sb.toString();
    }

    private String prepareData(String fData) {
        if (this.fEncodeData) {
            String encoded = Base64Helper.encodeString((String)fData);
            return "<![CDATA[" + encoded + "]]>";
        }
        return fData;
    }
}

