/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching;

import java.util.ArrayList;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;

public class XQDTJavaInterpreterRunner
extends AbstractInterpreterRunner {
    private static final String JAVA_EXEC = "java";
    private static final String JAVA_CP_ARG = "-cp";

    protected XQDTJavaInterpreterRunner(IInterpreterInstall install) {
        super(install);
    }

    protected String[] renderCommandLine(InterpreterConfig config) {
        IInterpreterInstall interpreter = this.getInstall();
        ArrayList<String> interpreterOwnArgs = new ArrayList<String>();
        String[] stringArray = interpreter.getInterpreterArguments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            interpreterOwnArgs.add(arg);
            ++n2;
        }
        String mainClass = (String)interpreterOwnArgs.remove(0);
        ArrayList<String> items = new ArrayList<String>();
        items.add(JAVA_EXEC);
        items.add(JAVA_CP_ARG);
        items.add(interpreter.getInstallLocation().toOSString());
        items.add(mainClass);
        for (Object arg : config.getInterpreterArgs()) {
            items.add((String)arg);
        }
        if (interpreterOwnArgs != null) {
            items.addAll(interpreterOwnArgs);
        }
        String queryFile = interpreter.getEnvironment().convertPathToString(config.getScriptFilePath());
        boolean foundQueryVar = false;
        int i = 0;
        while (i < items.size()) {
            if (((String)items.get(i)).equals("${query_file}")) {
                items.set(i, queryFile);
                for (Object arg : config.getScriptArgs()) {
                    items.add((String)arg);
                }
                foundQueryVar = true;
            }
            ++i;
        }
        if (!foundQueryVar) {
            items.add(queryFile);
            for (Object arg : config.getScriptArgs()) {
                items.add((String)arg);
            }
        }
        return items.toArray(new String[items.size()]);
    }
}

