/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryMainModule;

public class XQDTLaunchableTester
extends PropertyTester {
    private static final String PROPERTY_IS_MAIN_MODULE = "isMainModule";
    private static final String PROPERTY_IS_LIBRARY_MODULE = "isLibraryModule";
    private static final String PROPERTY_INTERPRETER_TYPE = "interpreterType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IModelElement element;
        if (!(receiver instanceof IAdaptable)) {
            throw new IllegalArgumentException("Element must be of type 'IAdaptable', is " + receiver == null ? "null" : receiver.getClass().getName());
        }
        if (receiver instanceof IModelElement) {
            element = (IModelElement)receiver;
        } else if (receiver instanceof IResource) {
            element = DLTKCore.create((IResource)((IResource)receiver));
            if (element == null) {
                return false;
            }
        } else {
            element = (IModelElement)((IAdaptable)receiver).getAdapter(IModelElement.class);
            if (element == null) {
                IResource resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class);
                element = DLTKCore.create((IResource)resource);
                if (element == null) {
                    return false;
                }
                return false;
            }
        }
        if (PROPERTY_IS_MAIN_MODULE.equals(property)) {
            return this.isMainModule(element);
        }
        if (PROPERTY_IS_LIBRARY_MODULE.equals(property)) {
            return this.isLibraryModule(element);
        }
        if (PROPERTY_INTERPRETER_TYPE.equals(property)) {
            return this.interpreterType(element, (String)expectedValue);
        }
        throw new IllegalArgumentException("Unknown test property '" + property + "'");
    }

    private boolean isMainModule(IModelElement element) {
        ISourceModule module;
        ModuleDeclaration modDecl;
        return element instanceof ISourceModule && (modDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)(module = (ISourceModule)element))) instanceof XQueryMainModule;
    }

    private boolean isLibraryModule(IModelElement element) {
        ISourceModule module;
        ModuleDeclaration modDecl;
        return element instanceof ISourceModule && (modDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)(module = (ISourceModule)element))) instanceof XQueryLibraryModule;
    }

    private boolean interpreterType(IModelElement element, String expectedValue) {
        try {
            IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)element.getScriptProject());
            if (install != null) {
                return install.getInterpreterInstallType().getId().equals(expectedValue);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

