/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.launching;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.launching.AbstractInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.wst.xquery.core.IXQDTUriResolver;
import org.eclipse.wst.xquery.core.utils.ResolverUtil;
import org.eclipse.wst.xquery.launching.IUriResolving;
import org.eclipse.wst.xquery.launching.ModuleSearchPath;
import org.eclipse.wst.xquery.launching.XQDTInterpreterInstallType;
import org.eclipse.wst.xquery.launching.XQDTLaunchingPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XQDTInterpreterInstall
extends AbstractInterpreterInstall
implements IUriResolving {
    private Map<String, String> fBuiltinSources;

    public XQDTInterpreterInstall(IInterpreterInstallType type, String id) {
        super(type, id);
    }

    public String getNatureId() {
        return "org.eclipse.wst.xquery.core.nature";
    }

    @Override
    public IXQDTUriResolver getResolver() {
        return ResolverUtil.createDefaultUriResolver();
    }

    private synchronized Map<String, String> getBuiltinSources() {
        if (this.fBuiltinSources == null) {
            this.fBuiltinSources = new HashMap<String, String>();
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            XQDTInterpreterInstallType installType = (XQDTInterpreterInstallType)this.getInterpreterInstallType();
            ModuleSearchPath[] moduleSearchPathArray = installType.getBuiltinModuleSearchPaths();
            int n = moduleSearchPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleSearchPath searchPath = moduleSearchPathArray[n2];
                try {
                    String strPath = searchPath.getPath();
                    Path path = new Path(strPath);
                    if (strPath.contains("${interpreterContainer}")) {
                        strPath = strPath.replace("${interpreterContainer}", this.getInstallLocation().getParent().toOSString());
                        path = new Path(strPath);
                        strPath = path.toPortableString();
                    }
                    if (searchPath.isRelative()) {
                        Enumeration urls = bundle.findEntries(path.toPortableString(), "*.xq*", true);
                        while (urls.hasMoreElements()) {
                            URL url = (URL)urls.nextElement();
                            String module = url.getPath().substring(url.getPath().indexOf(strPath) + strPath.length() + 1);
                            String displayName = this.getDisplayName(module);
                            String content = new String(Util.getInputStreamAsCharArray((InputStream)url.openStream(), (int)-1, (String)"UTF-8"));
                            this.fBuiltinSources.put(displayName, content);
                        }
                    } else {
                        IFileSystem fs = EFS.getLocalFileSystem();
                        IFileStore st = fs.getStore((IPath)path);
                        List<IFileStore> foundStores = this.findModulesIn(st);
                        for (IFileStore store : foundStores) {
                            URL url = store.toURI().toURL();
                            String module = url.getPath().substring(url.getPath().indexOf(strPath) + strPath.length() + 1);
                            String displayName = this.getDisplayName(module);
                            String content = new String(Util.getInputStreamAsCharArray((InputStream)url.openStream(), (int)-1, (String)"UTF-8"));
                            this.fBuiltinSources.put(displayName, content);
                        }
                    }
                }
                catch (Exception e) {
                    XQDTLaunchingPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.xquery.launching", e.getMessage(), (Throwable)e));
                }
                ++n2;
            }
        }
        return this.fBuiltinSources;
    }

    protected String getDisplayName(String module) {
        return module;
    }

    private List<IFileStore> findModulesIn(IFileStore store) {
        ArrayList<IFileStore> results = new ArrayList<IFileStore>();
        IFileInfo info = store.fetchInfo();
        if (info.isDirectory()) {
            try {
                IFileStore[] childStores;
                IFileStore[] iFileStoreArray = childStores = store.childStores(0, null);
                int n = childStores.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore child = iFileStoreArray[n2];
                    results.addAll(this.findModulesIn(child));
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (info.exists() && info.getName().matches(".*\\.xq.{0,4}")) {
            results.add(store);
        }
        return results;
    }

    public String getBuiltinModuleContent(String name) {
        return this.getBuiltinSources().get(name);
    }

    public String[] getBuiltinModules() {
        Map<String, String> sources = this.getBuiltinSources();
        return sources.keySet().toArray(new String[sources.size()]);
    }
}

