/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.launching.xqdoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.wst.xquery.core.utils.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXQDocRuntime {
    protected IScriptProject fProject;
    protected IProgressMonitor fMonitor;
    protected Collection<IPath> fQueries = new ArrayList<IPath>();
    protected IPath fFolder;
    protected String fStylesheet;

    public AbstractXQDocRuntime(IScriptProject projet, IProgressMonitor monitor) {
        this.fProject = projet;
        this.fMonitor = monitor;
    }

    public void init(Collection<IPath> queries, IPath destination, String stylesheet) {
        for (IPath path : queries) {
            this.fQueries.add(path);
        }
        this.fFolder = destination;
        this.fStylesheet = stylesheet;
    }

    public void run() throws Exception {
        this.generateXQDoc();
        this.excludeDestinationFromBuildPath();
        this.fProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    protected abstract void generateXQDoc() throws Exception;

    private void excludeDestinationFromBuildPath() {
        IPath relDir = PathUtil.makePathRelativeTo((IPath)this.fFolder, (IPath)this.fProject.getProject().getLocation());
        IPath absDir = this.fProject.getPath().append(relDir);
        try {
            IBuildpathEntry[] originalPath = this.fProject.getRawBuildpath();
            ArrayList<IBuildpathEntry> newEntries = new ArrayList<IBuildpathEntry>();
            IBuildpathEntry[] iBuildpathEntryArray = originalPath;
            int n = originalPath.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildpathEntry entry = iBuildpathEntryArray[n2];
                if (entry.getPath().isPrefixOf(absDir)) {
                    IPath[] excls = entry.getExclusionPatterns();
                    ArrayList<IPath> newExcls = new ArrayList<IPath>(excls.length);
                    IPath newEx = PathUtil.makePathRelativeTo((IPath)relDir, (IPath)entry.getPath()).addTrailingSeparator();
                    boolean alreadyExcluded = false;
                    IPath[] iPathArray = excls;
                    int n3 = excls.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPath path = iPathArray[n4];
                        if (newEx.equals((Object)path)) {
                            alreadyExcluded = true;
                        }
                        newExcls.add(path);
                        ++n4;
                    }
                    if (!alreadyExcluded) {
                        newExcls.add(newEx);
                    }
                    IBuildpathEntry newEntry = DLTKCore.newSourceEntry((IPath)entry.getPath(), (IPath[])newExcls.toArray(new IPath[newExcls.size()]));
                    newEntries.add(newEntry);
                } else {
                    newEntries.add(entry);
                }
                ++n2;
            }
            IBuildpathEntry[] newPath = new IBuildpathEntry[newEntries.size()];
            newEntries.toArray(newPath);
            this.fProject.setRawBuildpath(newPath, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ModelException modelException) {}
    }

    public static class FileCopy {
        public static void copy(String fromFileName, String toFileName) throws IOException {
            File fromFile = new File(fromFileName);
            File toFile = new File(toFileName);
            if (!fromFile.exists()) {
                throw new IOException("FileCopy: no such source file: " + fromFileName);
            }
            if (!fromFile.isFile()) {
                throw new IOException("FileCopy: can't copy directory: " + fromFileName);
            }
            if (!fromFile.canRead()) {
                throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
            }
            if (toFile.isDirectory()) {
                toFile = new File(toFile, fromFile.getName());
            }
            if (toFile.exists()) {
                if (!toFile.canWrite()) {
                    throw new IOException("FileCopy: destination file is unwriteable: " + toFileName);
                }
            } else {
                File dir;
                String parent = toFile.getParent();
                if (parent == null) {
                    parent = System.getProperty("user.dir");
                }
                if (!(dir = new File(parent)).exists()) {
                    throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
                }
                if (dir.isFile()) {
                    throw new IOException("FileCopy: destination is not a directory: " + parent);
                }
                if (!dir.canWrite()) {
                    throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
                }
            }
            FileInputStream from = null;
            FileOutputStream to = null;
            try {
                int bytesRead;
                from = new FileInputStream(fromFile);
                to = new FileOutputStream(toFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
            }
            catch (Throwable throwable) {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException iOException) {}
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

