/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core.model.ast;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.xquery.core.model.ast.IChildProcessor;
import org.eclipse.wst.xquery.core.model.ast.XQueryBaseURIDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryFunctionDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryModuleImport;
import org.eclipse.wst.xquery.core.model.ast.XQueryStringLiteral;
import org.eclipse.wst.xquery.core.model.ast.XQueryVarDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryXmlAttributeValueText;
import org.eclipse.wst.xquery.core.model.ast.XQueryXmlElementContentText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XQueryModule
extends ModuleDeclaration
implements IChildProcessor {
    private String fVersion = "1.0";
    private String fEncoding = "utf-8";
    private XQueryBaseURIDecl fBaseUri;
    private List<XQueryModuleImport> fImports = new ArrayList<XQueryModuleImport>(5);
    private HashMap<String, XQueryFunctionDecl> fFunctionDecls = new HashMap(5);
    private HashMap<String, XQueryVarDecl> fVarDecls = new HashMap(5);
    private List<XQueryStringLiteral> fStringLiterals = new ArrayList<XQueryStringLiteral>(5);
    private List<XQueryXmlElementContentText> fXmlElementContentTexts = new ArrayList<XQueryXmlElementContentText>(5);
    private List<XQueryXmlAttributeValueText> fXmlAttributeValuesTexts = new ArrayList<XQueryXmlAttributeValueText>(5);
    private List<Position> fKeywordPositions = new ArrayList<Position>();

    public XQueryModule(int length) {
        super(length);
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setVersion(String version) {
        this.fVersion = version;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public URI getBaseUri() {
        if (this.fBaseUri != null) {
            try {
                return new URI(this.fBaseUri.getUri().getValue());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setBaseUri(XQueryBaseURIDecl baseUri) {
        this.fBaseUri = baseUri;
    }

    public void addStatement(Statement statement) {
        super.addStatement((ASTNode)statement);
        switch (statement.getKind()) {
            case 3: {
                XQueryVarDecl varDecl = (XQueryVarDecl)statement;
                this.fVarDecls.put(varDecl.getName(), varDecl);
                break;
            }
            case 3002: {
                XQueryFunctionDecl functionDecl = (XQueryFunctionDecl)statement;
                this.fFunctionDecls.put(functionDecl.getUniqueName(), functionDecl);
                break;
            }
            case 10002: {
                this.fImports.add((XQueryModuleImport)statement);
                break;
            }
            case 10004: {
                this.fBaseUri = (XQueryBaseURIDecl)statement;
            }
        }
    }

    public void removeStatement(Statement statement) {
        super.removeStatement(statement);
        if (statement instanceof XQueryFunctionDecl) {
            XQueryFunctionDecl functionDecl = (XQueryFunctionDecl)statement;
            this.fFunctionDecls.remove(functionDecl.getUniqueName());
        } else if (statement instanceof XQueryVarDecl) {
            XQueryVarDecl varDecl = (XQueryVarDecl)statement;
            this.fVarDecls.remove(varDecl.getName());
        }
    }

    public void addXmlElementContents(XQueryXmlElementContentText content) {
        this.fXmlElementContentTexts.add(content);
    }

    public List<XQueryXmlElementContentText> getXmlElementContentText() {
        return this.fXmlElementContentTexts;
    }

    public void addXmlAttributeValuesText(XQueryXmlAttributeValueText content) {
        this.fXmlAttributeValuesTexts.add(content);
    }

    public List<XQueryXmlAttributeValueText> getXmlAttributeValuesText() {
        return this.fXmlAttributeValuesTexts;
    }

    public abstract String getNamespacePrefix();

    public XQueryFunctionDecl getFunction(String name) {
        return this.fFunctionDecls.get(name);
    }

    public XQueryVarDecl getVariable(String name) {
        return this.fVarDecls.get(name);
    }

    public List<XQueryStringLiteral> getStringLiterals() {
        return this.fStringLiterals;
    }

    public void addStringLiteral(XQueryStringLiteral string) {
        this.fStringLiterals.add(string);
    }

    public List<Position> getKeywords() {
        return this.fKeywordPositions;
    }

    public List<XQueryModuleImport> getImports() {
        return this.fImports;
    }

    public void setKeywordPositions(List<Position> keywordPositions) {
        this.fKeywordPositions = keywordPositions;
    }

    @Override
    public void processChild(ASTNode child) {
        if (child instanceof Statement) {
            Statement statement = (Statement)child;
            switch (statement.getKind()) {
                case 10002: {
                    this.addStatement(statement);
                    break;
                }
                case 10004: {
                    this.addStatement(statement);
                    break;
                }
                case 3002: {
                    this.addStatement(statement);
                    break;
                }
                case 3: {
                    this.addStatement(statement);
                }
            }
        }
    }
}

