/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core.model.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.wst.xquery.core.model.ast.IChildProcessor;
import org.eclipse.wst.xquery.core.model.ast.XQueryStringLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryModuleImport
extends Declaration
implements IChildProcessor {
    private XQueryStringLiteral fNamespaceUri;
    private List<XQueryStringLiteral> fHints = new ArrayList<XQueryStringLiteral>();

    public XQueryModuleImport(String name, int nameStart, int nameEnd, int declStart, int declEnd) {
        super(declStart, declEnd);
        this.setName(name);
        this.setNameStart(nameStart);
        this.setNameEnd(nameEnd);
    }

    public String getNamespacePrefix() {
        return this.getName();
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.setName(namespacePrefix);
    }

    public XQueryStringLiteral getNamespaceUri() {
        return this.fNamespaceUri;
    }

    public void setNamespaceUri(XQueryStringLiteral namespaceUri) {
        this.fNamespaceUri = namespaceUri;
    }

    public void addHint(XQueryStringLiteral hint) {
        this.fHints.add(hint);
    }

    public List<XQueryStringLiteral> getHints() {
        return this.fHints;
    }

    @Override
    public void processChild(ASTNode child) {
        if (child instanceof XQueryStringLiteral) {
            if (this.fNamespaceUri == null) {
                this.setNamespaceUri((XQueryStringLiteral)child);
            } else {
                this.addHint((XQueryStringLiteral)child);
            }
        }
    }

    public int getKind() {
        return 10002;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            visitor.endvisit((Statement)this);
        }
    }

    public String toString() {
        return String.valueOf(this.getNamespacePrefix()) + " = '" + this.getNamespaceUri().getValue() + "'";
    }

    public int matchStart() {
        return this.getNameStart();
    }

    public int matchLength() {
        return this.getNameEnd() - this.getNameStart();
    }
}

