/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.parser.antlr;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQDTLexer;

public class NewLazyTokenStream
implements TokenStream {
    private XQDTLexer tokenSource;
    private List<Token> tokens = new ArrayList<Token>(500);
    private boolean isWsExplicit = false;
    private int p = 0;
    protected int channel = 0;
    protected int lastMarker;
    boolean done = false;

    public NewLazyTokenStream() {
    }

    public NewLazyTokenStream(XQDTLexer tokenSource) {
        this();
        this.tokenSource = tokenSource;
    }

    public Token LT(int k) {
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.readReverseNthGoodToken(-k);
        }
        return this.readNthGoodToken(k);
    }

    public Token get(int i) {
        if (i >= this.tokens.size()) {
            return Token.EOF_TOKEN;
        }
        return this.tokens.get(i);
    }

    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    public String toString(int start, int stop) {
        if (start < 0) {
            start = 0;
        }
        if (this.p <= stop) {
            this.readNTokens(stop - this.p + 1);
        }
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= stop && i < this.tokens.size()) {
            sb.append(this.tokens.get(i).getText());
            ++i;
        }
        return sb.toString();
    }

    public String toString(Token start, Token stop) {
        return this.toString(start.getTokenIndex(), stop.getTokenIndex());
    }

    public int LA(int i) {
        return this.LT(i).getType();
    }

    public void consume() {
        if (this.done) {
            return;
        }
        ++this.p;
        if (!this.isWsExplicit) {
            this.jumpToFirstValidToken();
        }
    }

    public String getSourceName() {
        return this.getTokenSource().getSourceName();
    }

    public int index() {
        return this.p;
    }

    public int mark() {
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void seek(int index) {
        this.p = index;
        this.done = false;
    }

    public int size() {
        return this.tokens.size();
    }

    public String toString() {
        return this.toString(0, this.tokens.size() - 1);
    }

    public void setTokenSource(XQDTLexer source) {
        this.tokenSource = source;
        this.setWsExplicit(source.isWsExplicit());
        if (this.p < this.tokens.size()) {
            int rIndex = this.p > 0 ? ((CommonToken)this.tokens.get(this.p - 1)).getStopIndex() : 0;
            this.tokenSource.rewindToIndex(rIndex + 1);
            int i = this.tokens.size() - 1;
            while (i >= this.p) {
                this.tokens.remove(i);
                --i;
            }
        }
        if (!this.isWsExplicit) {
            this.jumpToFirstValidToken();
        }
    }

    public void setWsExplicit(boolean explicit) {
        this.isWsExplicit = explicit;
        if (!explicit) {
            this.jumpToFirstValidToken();
        }
    }

    private Token readNthGoodToken(int n) {
        int count = this.tokens.size();
        int avt = count - this.p;
        int i = 1;
        int j = 0;
        Token t = null;
        while (i <= n) {
            if (j < avt) {
                t = this.tokens.get(this.p + j);
            } else {
                t = this.tokenSource.nextToken();
                if (t == Token.EOF_TOKEN) {
                    return t;
                }
                t.setTokenIndex(count++);
                this.tokens.add(t);
            }
            if (this.isWsExplicit || t.getChannel() == this.channel) {
                ++i;
            }
            ++j;
        }
        return t;
    }

    private Token readReverseNthGoodToken(int n) {
        if (n == 0 || this.p - n < 0) {
            return null;
        }
        int i = 1;
        int j = 0;
        Token t = null;
        while (this.p - 1 - j >= 0) {
            t = this.get(this.p - 1 - j);
            if ((this.isWsExplicit || t.getChannel() == this.channel) && i++ == n) {
                return t;
            }
            ++j;
        }
        return null;
    }

    private void readNTokens(int n) {
        Token t = null;
        int i = 0;
        while (i < n) {
            if (this.tokens.size() <= this.p + i) {
                t = this.tokenSource.nextToken();
                if (t == Token.EOF_TOKEN) {
                    return;
                }
                t.setTokenIndex(this.p + i);
                this.tokens.add(t);
            }
            ++i;
        }
    }

    public void jumpToFirstValidToken() {
        Token t = this.LT(1);
        if (t != Token.EOF_TOKEN) {
            this.done = false;
            this.p = t.getTokenIndex();
        }
    }
}

