/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.parser.antlr;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.wst.xquery.compiler.problem.SyntaxProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XQDTLexer
extends Lexer {
    private boolean fIsWsExplicit = false;
    private IProblemReporter fReporter;
    private String fFileName;
    private List<DefaultProblem> fProblems = new ArrayList<DefaultProblem>();

    public XQDTLexer() {
    }

    public XQDTLexer(CharStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public void rewindToIndex(int index) {
        ANTLRStringStream stream = (ANTLRStringStream)this.input;
        stream.seek(index);
        int i = this.fProblems.size() - 1;
        while (i >= 0) {
            DefaultProblem problem = this.fProblems.get(i);
            if (problem.getSourceStart() < index) break;
            this.fProblems.remove(i);
            --i;
        }
    }

    public boolean isWsExplicit() {
        return this.fIsWsExplicit;
    }

    public void setIsWsExplicit(boolean wsExplicit) {
        this.fIsWsExplicit = wsExplicit;
    }

    public void addToStack(List<XQDTLexer> stack) {
        stack.add(this);
    }

    public void setReporter(IProblemReporter reporter) {
        this.fReporter = reporter;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    public void postErrors() {
        for (DefaultProblem problem : this.fProblems) {
            if (problem.getSourceStart() > this.input.index()) break;
            this.fReporter.reportProblem((IProblem)problem);
        }
        this.fProblems.clear();
    }

    public void reportError(RecognitionException e) {
        if (this.fReporter != null && this.input.size() != 0) {
            String errorMessage = this.getErrorMessage(e, this.getTokenNames());
            SyntaxProblem problem = new SyntaxProblem(this.fFileName, errorMessage, e.index, e.index + 1, e.line);
            this.fProblems.add(problem);
        }
        super.reportError(e);
    }
}

